/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import java.util.function.IntSupplier;

public abstract class RadixCalculator {
    public static final int NULL_RADIX = -1;
    protected static final int RADIX_BITS = 24;
    protected static final long LENGTH_BITS = -144115188075855872L;
    protected static final int LENGTH_MASK = 0xFE0000;
    protected static final int HASHCODE_MASK = 65535;

    public abstract int radixOf(long var1);

    public static class LongRadixCalculator
    extends RadixCalculator {
        private final IntSupplier radixShift;

        public LongRadixCalculator(IntSupplier radixShift) {
            this.radixShift = radixShift;
        }

        @Override
        public int radixOf(long value) {
            if (value == 0L) {
                return -1;
            }
            long val1 = value & 0x1FFFFFFFFFFFFFFL;
            return (int)(val1 >>>= this.radixShift.getAsInt());
        }
    }

    public static class StringRadixCalculator
    extends RadixCalculator {
        @Override
        public int radixOf(long value) {
            if (value == 0L) {
                return -1;
            }
            int index = (int)(value >>> 40);
            index = (index & 0xFE0000) >>> 1 | index & 0xFFFF;
            return index;
        }
    }
}

