/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.impl.factory.Lists;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.csv.reader.BufferedCharSeeker;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharReadableChunker;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Chunker;
import org.neo4j.csv.reader.ClosestNewLineChunker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.HeaderSkipper;
import org.neo4j.csv.reader.Mark;
import org.neo4j.csv.reader.MultiLineChunker;
import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.Source;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.csv.CsvInputChunk;
import org.neo4j.internal.batchimport.input.csv.CsvInputChunkProxy;
import org.neo4j.internal.batchimport.input.csv.DataFactories;
import org.neo4j.internal.batchimport.input.csv.Decorator;
import org.neo4j.internal.batchimport.input.csv.EagerCsvInputChunk;
import org.neo4j.internal.batchimport.input.csv.EagerParserChunker;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.LazyCsvInputChunk;
import org.neo4j.internal.batchimport.input.csv.Type;

class CsvInputIterator
implements SourceTraceability,
Closeable {
    private static final ImmutableMap<String, Type> TYPES = Lists.immutable.of((Object[])Type.values()).toMap(Enum::name, (Function & Serializable)t -> t).toImmutable();
    private final CharReadable stream;
    private final Chunker chunker;
    private final int groupId;
    private final Decorator decorator;
    private final Supplier<CsvInputChunk> realInputChunkSupplier;

    CsvInputIterator(CharReadable stream, Decorator decorator, Header header, Configuration config, IdType idType, Collector badCollector, Extractors extractors, int groupId, boolean autoSkipHeaders, boolean delimitIds) {
        this.stream = stream;
        this.decorator = decorator;
        this.groupId = groupId;
        if (config.legacyMultilineFields()) {
            this.chunker = new EagerParserChunker(stream, idType, header, badCollector, extractors, 1000, config, decorator, autoSkipHeaders, delimitIds);
            this.realInputChunkSupplier = EagerCsvInputChunk::new;
        } else {
            this.chunker = CsvInputIterator.createChunker(stream, config, CsvInputIterator.headerSkip(header, autoSkipHeaders, config, idType));
            this.realInputChunkSupplier = () -> new LazyCsvInputChunk(idType, config.delimiter(), badCollector, extractors, this.chunker.newChunk(), config, decorator, header, delimitIds);
        }
    }

    CsvInputIterator(CharReadable stream, Decorator decorator, Header.Factory headerFactory, IdType idType, Configuration config, Groups groups, Collector badCollector, Extractors extractors, int groupId, boolean autoSkipHeader, boolean delimitIds, Header.Monitor monitor) throws IOException {
        this(stream, decorator, CsvInputIterator.extractHeader(stream, headerFactory, idType, config, groups, monitor), config, idType, badCollector, extractors, groupId, autoSkipHeader, delimitIds);
    }

    static Header extractHeader(CharReadable stream, Header.Factory headerFactory, IdType idType, Configuration config, Groups groups, Header.Monitor monitor) throws IOException {
        if (!headerFactory.isDefined()) {
            CharSeeker headerSeeker = CsvInputIterator.seeker(stream.sourceDescription(), config, Readables.extractFirstLineFrom((CharReadable)stream));
            return headerFactory.create(headerSeeker, config, idType, groups, monitor);
        }
        return headerFactory.create(null, null, null, null, monitor);
    }

    private static CharSeeker seeker(String sourceDescription, Configuration config, char[] data) {
        CharReadableChunker.ChunkImpl firstChunk = new CharReadableChunker.ChunkImpl(Arrays.copyOf(data, data.length + 1));
        firstChunk.initialize(0, data.length, sourceDescription);
        return CsvInputIterator.seeker((Source.Chunk)firstChunk, config);
    }

    static HeaderSkipper headerSkip(Header header, boolean autoSkipHeaders, Configuration config, IdType idType) {
        if (!autoSkipHeaders) {
            return HeaderSkipper.NO_SKIP;
        }
        return (data, offset, length) -> {
            int initialEolSkipped = 0;
            while (BufferedCharSeeker.isEolChar((char)data[offset])) {
                ++offset;
                ++initialEolSkipped;
            }
            char[] firstLine = Readables.extractFirstLineFrom((char[])data, (int)offset, (int)length);
            if (firstLine.length > 0 && (CsvInputIterator.isParsableHeader(config, idType, firstLine) || !CsvInputIterator.valueTypesMatchesHeader(header, config, firstLine))) {
                return initialEolSkipped + firstLine.length;
            }
            return 0;
        };
    }

    private static boolean valueTypesMatchesHeader(Header header, Configuration config, char[] firstLine) {
        try {
            CharSeeker seeker = CsvInputIterator.seeker("", config, firstLine);
            Mark mark = new Mark();
            char delimiter = config.delimiter();
            for (int i = 0; i < header.entries().length; ++i) {
                Header.Entry entry = header.entries()[i];
                if (!seeker.seek(mark, (int)delimiter)) {
                    return false;
                }
                if (entry.type() == Type.IGNORE) continue;
                Extractor<?> extractor = entry.extractor();
                try {
                    seeker.tryExtract(mark, extractor, entry.optionalParameter());
                    continue;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static boolean isParsableHeader(Configuration config, IdType idType, char[] firstLine) {
        CharSeeker seeker = CsvInputIterator.seeker("", config, firstLine);
        try {
            Header.Entry[] entries = DataFactories.parseHeaderEntries(seeker, config, idType, new Groups(), ZoneId::systemDefault, (sourceDescription, entryIndex, spec, extractors, idExtractor, groups, monitor) -> new Header.Entry(spec.rawEntry(), spec.name(), CsvInputIterator.typeFromSpec(spec.type()), null, extractors.string()), Header.NO_MONITOR);
            if (Arrays.stream(entries).anyMatch(e -> e.type() != Type.PROPERTY && e.type() != Type.IGNORE)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static Type typeFromSpec(String specType) {
        Type type = Type.PROPERTY;
        if (specType != null) {
            type = (Type)((Object)TYPES.getIfAbsentValue((Object)specType.toUpperCase(Locale.ROOT), (Object)type));
        }
        return type;
    }

    private static Chunker createChunker(CharReadable stream, Configuration config, HeaderSkipper headerSkip) {
        if (config.multilineDocuments().test(stream.sourceDescription())) {
            return new MultiLineChunker(stream, config, headerSkip);
        }
        return new ClosestNewLineChunker(stream, config.bufferSize(), headerSkip);
    }

    public boolean next(CsvInputChunkProxy proxy) throws IOException {
        proxy.ensureInstantiated(this.realInputChunkSupplier, this.groupId);
        return proxy.fillFrom(this.chunker);
    }

    @Override
    public void close() throws IOException {
        this.chunker.close();
        this.decorator.close();
    }

    public String sourceDescription() {
        return this.stream.sourceDescription();
    }

    public long position() {
        return this.chunker.position();
    }

    public float compressionRatio() {
        return this.stream.compressionRatio();
    }

    static CharSeeker seeker(Source.Chunk chunk, Configuration config) {
        return new BufferedCharSeeker(Source.singleChunk((Source.Chunk)chunk), config);
    }
}

