/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.parquet.schema.PrimitiveType;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.parquet.EntityType;
import org.neo4j.internal.batchimport.input.parquet.ParquetColumnType;
import org.neo4j.internal.batchimport.input.parquet.ParquetLogicalColumnType;
import org.neo4j.values.storable.Value;

record ParquetColumn(String columnName, HeaderDefinition headerDefinition, String propertyName, String groupName, PrimitiveType primitiveType, ParquetLogicalColumnType logicalColumnType, ParquetColumnType columnType, boolean isArray, String rawConfiguration, Map<String, String> configuration) {
    static ParquetColumn from(HeaderDefinition headerDefinition, EntityType knownEntityType, PrimitiveType primitiveType) {
        String targetColumnName = headerDefinition.targetColumnName();
        boolean isArray = ParquetColumn.hasArrayDefinition(targetColumnName);
        String columnName = targetColumnName.replace("[]", "");
        EnclosureMatch groupNameMatch = ParquetColumn.extractGroupName(columnName);
        EnclosureMatch configurationMatch = ParquetColumn.extractConfiguration(columnName);
        columnName = groupNameMatch.removeFrom(columnName);
        columnName = configurationMatch.adjustAfterRemovalOf(groupNameMatch).removeFrom(columnName);
        String propertyName = ParquetColumn.extractPropertyName(columnName);
        ParquetLogicalColumnType logicalColumnType = ParquetLogicalColumnType.resolve(ParquetColumn.extractLogicalColumnType(columnName), knownEntityType);
        ParquetColumnType columnType = ParquetColumnType.resolve(ParquetColumn.extractColumnType(logicalColumnType, columnName));
        String rawConfiguration = configurationMatch.getMatch();
        Map<String, String> configuration = ParquetColumn.parseConfiguration(rawConfiguration);
        return new ParquetColumn(columnName, headerDefinition, propertyName, groupNameMatch.getMatch(), primitiveType, logicalColumnType, columnType, isArray, rawConfiguration, configuration);
    }

    private static EnclosureMatch extractConfiguration(String columnNameValue) {
        return EnclosureMatch.parseEnclosure('{', '}', columnNameValue, true);
    }

    private static EnclosureMatch extractGroupName(String columnNameValue) {
        return EnclosureMatch.parseEnclosure('(', ')', columnNameValue, false);
    }

    private static Map<String, String> parseConfiguration(String rawConfiguration) {
        if (rawConfiguration == null) {
            return Collections.emptyMap();
        }
        return Value.parseStringMap((CharSequence)rawConfiguration);
    }

    String idLabel() {
        return this.configuration.get("label");
    }

    IdType columnIdType() {
        String idTypeValue = this.configuration.get("id-type");
        if (idTypeValue == null || idTypeValue.isBlank()) {
            return null;
        }
        return switch (idTypeValue.toUpperCase(Locale.ROOT)) {
            case "INT" -> IdType.INTEGER;
            case "LONG" -> IdType.INTEGER;
            case "STRING" -> IdType.STRING;
            case "ACTUAL" -> IdType.ACTUAL;
            default -> IdType.ACTUAL;
        };
    }

    IdType relationshipColumnIdType(Groups groups) {
        IdType columnIdType = this.columnIdType();
        if (columnIdType != null) {
            return columnIdType;
        }
        String groupType = groups.get(this.groupName()).specificIdType();
        return groupType != null ? IdType.valueOf((String)groupType) : null;
    }

    private static String extractLogicalColumnType(String columnNameValue) {
        if (!columnNameValue.contains(":")) {
            return null;
        }
        int typeSplitPosition = columnNameValue.lastIndexOf(":");
        return columnNameValue.substring(typeSplitPosition + 1).trim();
    }

    private static String extractColumnType(ParquetLogicalColumnType logicalColumnType, String columnNameValue) {
        if (!columnNameValue.contains(":") || logicalColumnType != ParquetLogicalColumnType.PROPERTY) {
            return null;
        }
        int typeSplitPosition = columnNameValue.lastIndexOf(":");
        return columnNameValue.substring(typeSplitPosition + 1).trim();
    }

    private static String extractPropertyName(String columnNameValue) {
        int typeSplitPosition = columnNameValue.lastIndexOf(":");
        String columnName = typeSplitPosition > -1 ? columnNameValue.substring(0, typeSplitPosition).trim() : columnNameValue;
        return columnName.isBlank() ? null : columnName;
    }

    private static boolean hasArrayDefinition(String columnName) {
        if (!columnName.contains(":")) {
            return columnName.endsWith("[]");
        }
        int typeSplitPosition = columnName.lastIndexOf(":");
        return columnName.substring(typeSplitPosition).contains("[]");
    }

    boolean isRaw() {
        return this.columnType == ParquetColumnType.RAW;
    }

    boolean hasConfiguration() {
        return this.rawConfiguration() != null;
    }

    ParquetColumn withoutArray() {
        return new ParquetColumn(this.columnName(), this.headerDefinition(), this.propertyName(), this.groupName(), this.primitiveType(), this.logicalColumnType(), this.columnType(), false, this.rawConfiguration(), this.configuration());
    }

    ParquetColumn withColumnType(ParquetColumnType columnType) {
        return new ParquetColumn(this.columnName(), this.headerDefinition(), this.propertyName(), this.groupName(), this.primitiveType(), this.logicalColumnType(), columnType, this.isArray(), this.rawConfiguration(), this.configuration());
    }

    boolean hasPropertyName() {
        return this.propertyName != null && !this.propertyName.isBlank();
    }

    boolean isIdColumn() {
        return this.logicalColumnType == ParquetLogicalColumnType.ID;
    }

    boolean isLabelColumn() {
        return this.logicalColumnType == ParquetLogicalColumnType.LABEL;
    }

    boolean isStartId() {
        return this.logicalColumnType == ParquetLogicalColumnType.START_ID;
    }

    boolean isEndId() {
        return this.logicalColumnType == ParquetLogicalColumnType.END_ID;
    }

    boolean isType() {
        return this.logicalColumnType == ParquetLogicalColumnType.TYPE;
    }

    boolean isIgnoredColumn() {
        return this.logicalColumnType == ParquetLogicalColumnType.IGNORED;
    }

    boolean isIdentifier() {
        return Boolean.parseBoolean(this.configuration.get("identifier"));
    }

    Supplier<ZoneId> getTimezone(Supplier<ZoneId> defaultTimezoneSupplier) {
        if (!this.hasConfiguration()) {
            return defaultTimezoneSupplier;
        }
        return () -> {
            String zoneIdValue = this.configuration.get("timezone");
            if (zoneIdValue == null) {
                return (ZoneId)defaultTimezoneSupplier.get();
            }
            return ZoneId.of(zoneIdValue);
        };
    }

    static String getReservedColumns(EntityType entityType) {
        return "Column types: " + Arrays.toString((Object[])ParquetColumnType.values()) + ", logical types: " + ParquetLogicalColumnType.getReservedColumns(entityType);
    }

    static interface HeaderDefinition {
        public String targetColumnName();

        public String parquetColumnName();

        default public DefaultHeaderDefinition addParquetColumnName(String parquetColumnName) {
            return new DefaultHeaderDefinition(this.targetColumnName(), parquetColumnName);
        }

        public static HeaderDefinition from(String columnName, String originalColumn) {
            return new DefaultHeaderDefinition(columnName, originalColumn);
        }

        public static HeaderDefinition from(String columnName) {
            return new SingleRowHeaderDefinition(columnName);
        }
    }

    private record EnclosureMatch(char startSymbol, char endSymbol, int startIndex, int endIndex, String parsedMatch) {
        static EnclosureMatch parseEnclosure(char startCharacter, char endCharacter, String content, boolean includeSymbols) {
            if (!content.contains(":")) {
                return EnclosureMatch.unmatched(startCharacter, endCharacter);
            }
            int startPos = EnclosureMatch.findLastRegularColon(content);
            int startIndex = content.indexOf("" + startCharacter, startPos);
            if (startIndex == -1) {
                return EnclosureMatch.unmatched(startCharacter, endCharacter);
            }
            int endIndex = content.lastIndexOf("" + endCharacter);
            if (endIndex == -1) {
                return EnclosureMatch.unmatched(startCharacter, endCharacter);
            }
            String match = content.substring(startIndex + 1, endIndex).trim();
            if (!includeSymbols) {
                return new EnclosureMatch(startCharacter, endCharacter, startIndex, endIndex, match);
            }
            return new EnclosureMatch(startCharacter, endCharacter, startIndex, endIndex, "%c%s%c".formatted(Character.valueOf(startCharacter), match, Character.valueOf(endCharacter)));
        }

        private static int findLastRegularColon(String content) {
            int lastColonIndex = content.lastIndexOf(":");
            int lastCurlyStartIndex = content.lastIndexOf("{");
            int lastCurlyEndIndex = content.lastIndexOf("}");
            int lastParenthesisStartIndex = content.lastIndexOf("(");
            int lastParenthesisEndIndex = content.lastIndexOf(")");
            if (lastCurlyStartIndex < lastColonIndex && lastCurlyEndIndex > lastColonIndex) {
                lastColonIndex = content.substring(0, lastCurlyStartIndex).lastIndexOf(":");
            }
            if (lastParenthesisStartIndex != -1 && lastParenthesisEndIndex != -1 && lastParenthesisStartIndex < lastColonIndex) {
                lastColonIndex = content.substring(0, lastParenthesisStartIndex).lastIndexOf(":");
            }
            return lastColonIndex;
        }

        private static EnclosureMatch unmatched(char start, char end) {
            return new EnclosureMatch(start, end, -1, -1, null);
        }

        String removeFrom(String content) {
            if (!this.matches()) {
                return content;
            }
            String startString = content.substring(0, this.startIndex);
            if (this.endIndex == content.length() - 1) {
                return startString;
            }
            return "%s%s".formatted(startString, content.substring(this.endIndex + 1));
        }

        EnclosureMatch adjustAfterRemovalOf(EnclosureMatch other) {
            if (!this.matches() || !other.matches()) {
                return this;
            }
            int otherMatchLength = other.endIndex - other.startIndex + 1;
            return new EnclosureMatch(this.startSymbol, this.endSymbol, this.startIndex - otherMatchLength, this.endIndex - otherMatchLength, this.parsedMatch);
        }

        String getMatch() {
            return this.parsedMatch;
        }

        private boolean matches() {
            return this.parsedMatch != null;
        }
    }

    record SingleRowHeaderDefinition(String targetColumnName) implements HeaderDefinition
    {
        @Override
        public String parquetColumnName() {
            return this.targetColumnName();
        }
    }

    record DefaultHeaderDefinition(String targetColumnName, String parquetColumnName) implements HeaderDefinition
    {
    }
}

