/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import java.util.Locale;

public enum ParquetColumnType {
    RAW(null, null),
    BOOLEAN("BOOLEAN", null),
    POINT("POINT", null),
    DATE("DATE", null),
    TIME("TIME", null),
    DATE_TIME("DATETIME", null),
    LOCAL_TIME("LOCALTIME", null),
    LOCAL_DATE_TIME("LOCALDATETIME", null),
    DURATION("DURATION", null),
    STRING("STRING", null),
    LONG("LONG", null),
    DOUBLE("DOUBLE", null),
    INT("INT", LONG),
    FLOAT("FLOAT", DOUBLE),
    BYTE("BYTE", LONG),
    SHORT("SHORT", LONG),
    CHAR("CHAR", STRING),
    VECTOR("VECTOR", null);

    private final String reservedWord;
    private final ParquetColumnType convertedType;

    private ParquetColumnType(String reservedWord, ParquetColumnType convertedType) {
        this.reservedWord = reservedWord;
        this.convertedType = convertedType;
    }

    static ParquetColumnType resolve(String typeName) {
        if (typeName == null) {
            return RAW;
        }
        typeName = typeName.toUpperCase(Locale.ROOT);
        for (ParquetColumnType value : ParquetColumnType.values()) {
            if (!typeName.equals(value.reservedWord)) continue;
            return value;
        }
        throw new IllegalArgumentException("Could not find any type matching: " + typeName);
    }

    boolean needsConversion() {
        return this.convertedType != null;
    }

    ParquetColumnType convertedType() {
        return this.convertedType;
    }
}

