/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import java.util.Arrays;
import java.util.Locale;
import org.neo4j.internal.batchimport.input.parquet.EntityType;

enum ParquetLogicalColumnType {
    ID("ID", EntityType.NODE),
    LABEL("LABEL", EntityType.NODE),
    START_ID("START_ID", EntityType.RELATIONSHIP),
    END_ID("END_ID", EntityType.RELATIONSHIP),
    TYPE("TYPE", EntityType.RELATIONSHIP),
    IGNORED("IGNORE", EntityType.COMMON),
    PROPERTY(null, EntityType.COMMON);

    private final String typeName;
    final EntityType entityType;

    private ParquetLogicalColumnType(String typeName, EntityType entityType) {
        this.typeName = typeName;
        this.entityType = entityType;
    }

    static ParquetLogicalColumnType resolve(String logicalColumnTypeValue, EntityType entityTypeFilter) throws IllegalArgumentException {
        if (logicalColumnTypeValue == null) {
            return PROPERTY;
        }
        logicalColumnTypeValue = logicalColumnTypeValue.toUpperCase(Locale.ROOT);
        for (ParquetLogicalColumnType type : ParquetLogicalColumnType.values()) {
            if (!logicalColumnTypeValue.equals(type.typeName) || entityTypeFilter != null && type.entityType != entityTypeFilter && type.entityType != EntityType.COMMON) continue;
            return type;
        }
        return PROPERTY;
    }

    public static String getReservedColumns(EntityType entityType) {
        return Arrays.stream(ParquetLogicalColumnType.values()).filter(value -> value.entityType == entityType).toList().toString();
    }
}

