/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import org.neo4j.batchimport.api.Configuration;
import org.neo4j.internal.batchimport.staging.DynamicProcessorAssigner;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionSupervisor;
import org.neo4j.internal.batchimport.staging.MultiExecutionMonitor;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.time.Clocks;

public class ExecutionSupervisors {
    private ExecutionSupervisors() {
    }

    public static void superviseDynamicExecution(Stage stage) {
        ExecutionSupervisors.superviseDynamicExecution(ExecutionMonitor.INVISIBLE, stage);
    }

    public static void superviseDynamicExecution(ExecutionMonitor monitor, Stage stage) {
        ExecutionSupervisors.superviseDynamicExecution(monitor, Configuration.DEFAULT, stage);
    }

    public static void superviseDynamicExecution(ExecutionMonitor monitor, Configuration config, Stage stage) {
        ExecutionSupervisors.superviseExecution(ExecutionSupervisors.withDynamicProcessorAssignment(monitor, config), stage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void superviseExecution(ExecutionMonitor monitor, Stage stage) {
        ExecutionSupervisor supervisor = new ExecutionSupervisor(Clocks.systemClock(), monitor);
        StageExecution execution = null;
        try {
            execution = stage.execute();
            supervisor.supervise(execution);
        }
        finally {
            stage.close();
            if (execution != null) {
                execution.assertHealthy();
            }
        }
    }

    public static ExecutionMonitor withDynamicProcessorAssignment(ExecutionMonitor monitor, Configuration config) {
        DynamicProcessorAssigner dynamicProcessorAssigner = new DynamicProcessorAssigner(config);
        return new MultiExecutionMonitor(monitor, dynamicProcessorAssigner);
    }
}

