/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.cursors;

import org.neo4j.cypher.internal.runtime.ResourceManagedCursorPool;
import org.neo4j.cypher.internal.util.AssertionRunner;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.TraceableCursor;
import org.neo4j.memory.MemoryTracker;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005q4A!\u0005\n\u0001?!AQ\u0006\u0001B\u0001B\u0003&a\u0006\u0003\u00052\u0001\t\u0005\t\u0015)\u00033\u0011!a\u0004A!A!\u0002\u0013i\u0004\"B\"\u0001\t\u0003!\u0005B\u0002&\u0001A\u0003&1\n\u0003\u0004O\u0001\u0001\u0006Ka\u0014\u0005\u0007%\u0002\u0001\u000b\u0015B*\t\u000bY\u0003A\u0011A,\t\u000ba\u0003A\u0011A-\t\u000bi\u0003A\u0011A.\t\u000bq\u0003A\u0011I/\t\u000b\u0011\u0004A\u0011I3\t\u000b%\u0004A\u0011\u00016\t\u000bA\u0004A\u0011I3\t\u000bE\u0004A\u0011\t:\t\u000bU\u0004A\u0011\u0002<\u0003#\u0015C\bO]3tg&|gnQ;sg>\u00148O\u0003\u0002\u0014)\u000591-\u001e:t_J\u001c(BA\u000b\u0017\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0006\r\u0002\u0011%tG/\u001a:oC2T!!\u0007\u000e\u0002\r\rL\b\u000f[3s\u0015\tYB$A\u0003oK>$$NC\u0001\u001e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001%\u000b\t\u0003C\u001dj\u0011A\t\u0006\u0003G\u0011\n1!\u00199j\u0015\t)c%\u0001\u0004lKJtW\r\u001c\u0006\u0003/iI!\u0001\u000b\u0012\u0003-\u0011+g-Y;mi\u000ecwn]3MSN$XM\\1cY\u0016\u0004\"AK\u0016\u000e\u0003QI!\u0001\f\u000b\u00033I+7o\\;sG\u0016l\u0015M\\1hK\u0012\u001cUO]:peB{w\u000e\\\u0001\u000eGV\u00148o\u001c:GC\u000e$xN]=\u0011\u0005\u0005z\u0013B\u0001\u0019#\u00055\u0019UO]:pe\u001a\u000b7\r^8ss\u0006i1-\u001e:t_J\u001cuN\u001c;fqR\u0004\"a\r\u001e\u000e\u0003QR!!\u000e\u001c\u0002\u000f\r|g\u000e^3yi*\u0011q\u0007O\u0001\na\u0006<WmY1dQ\u0016T!!\u000f\u000e\u0002\u0005%|\u0017BA\u001e5\u00055\u0019UO]:pe\u000e{g\u000e^3yi\u0006iQ.Z7pef$&/Y2lKJ\u0004\"AP!\u000e\u0003}R!\u0001\u0011\u000e\u0002\r5,Wn\u001c:z\u0013\t\u0011uHA\u0007NK6|'/\u001f+sC\u000e\\WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0015;\u0005*\u0013\t\u0003\r\u0002i\u0011A\u0005\u0005\u0006[\u0011\u0001\rA\f\u0005\u0006c\u0011\u0001\rA\r\u0005\u0006y\u0011\u0001\r!P\u0001\f?:|G-Z\"veN|'\u000f\u0005\u0002\"\u0019&\u0011QJ\t\u0002\u000b\u001d>$WmQ;sg>\u0014\u0018aF0sK2\fG/[8og\"L\u0007oU2b]\u000e+(o]8s!\t\t\u0003+\u0003\u0002RE\t1\"+\u001a7bi&|gn\u001d5jaN\u001b\u0017M\\\"veN|'/A\b`aJ|\u0007/\u001a:us\u000e+(o]8s!\t\tC+\u0003\u0002VE\tq\u0001K]8qKJ$\u0018pQ;sg>\u0014\u0018A\u00038pI\u0016\u001cUO]:peV\t1*\u0001\fsK2\fG/[8og\"L\u0007oU2b]\u000e+(o]8s+\u0005y\u0015A\u00049s_B,'\u000f^=DkJ\u001cxN]\u000b\u0002'\u0006A\u0011n]\"m_N,G\rF\u0001_!\ty&-D\u0001a\u0015\u0005\t\u0017!B:dC2\f\u0017BA2a\u0005\u001d\u0011un\u001c7fC:\fQb\u00197pg\u0016Le\u000e^3s]\u0006dG#\u00014\u0011\u0005};\u0017B\u00015a\u0005\u0011)f.\u001b;\u0002\u001fM,GoS3s]\u0016dGK]1dKJ$\"AZ6\t\u000b1l\u0001\u0019A7\u0002\rQ\u0014\u0018mY3s!\t\tc.\u0003\u0002pE\t\u00012*\u001a:oK2\u0014V-\u00193Ue\u0006\u001cWM]\u0001\rG2|7/Z\"veN|'o]\u0001\u001bg\u0016$8)\u001e:t_J4\u0015m\u0019;pef\fe\u000eZ\"p]R,\u0007\u0010\u001e\u000b\u0004MN$\b\"B\u0017\u0010\u0001\u0004q\u0003\"B\u0019\u0010\u0001\u0004\u0011\u0014!\u00058piJ+G/\u001e:oK\u0012$v\u000eU8pYR\u0011al\u001e\u0005\u0006qB\u0001\r!_\u0001\u0007GV\u00148o\u001c:\u0011\u0005\u0005R\u0018BA>#\u0005\u0019\u0019UO]:pe\u0002")
public class ExpressionCursors
extends DefaultCloseListenable
implements ResourceManagedCursorPool {
    private CursorFactory cursorFactory;
    private CursorContext cursorContext;
    private final MemoryTracker memoryTracker;
    private NodeCursor _nodeCursor;
    private RelationshipScanCursor _relationshipScanCursor;
    private PropertyCursor _propertyCursor;

    public NodeCursor nodeCursor() {
        if (this._nodeCursor == null) {
            this._nodeCursor = this.cursorFactory.allocateNodeCursor(this.cursorContext, this.memoryTracker);
        }
        if (AssertionRunner.ASSERTIONS_ENABLED && !this.notReturnedToPool((Cursor)this._nodeCursor)) {
            throw new AssertionError((Object)"assertion failed");
        }
        return this._nodeCursor;
    }

    public RelationshipScanCursor relationshipScanCursor() {
        if (this._relationshipScanCursor == null) {
            this._relationshipScanCursor = this.cursorFactory.allocateRelationshipScanCursor(this.cursorContext, this.memoryTracker);
        }
        if (AssertionRunner.ASSERTIONS_ENABLED && !this.notReturnedToPool((Cursor)this._relationshipScanCursor)) {
            throw new AssertionError((Object)"assertion failed");
        }
        return this._relationshipScanCursor;
    }

    public PropertyCursor propertyCursor() {
        if (this._propertyCursor == null) {
            this._propertyCursor = this.cursorFactory.allocatePropertyCursor(this.cursorContext, this.memoryTracker);
        }
        if (AssertionRunner.ASSERTIONS_ENABLED && !this.notReturnedToPool((Cursor)this._propertyCursor)) {
            throw new AssertionError((Object)"assertion failed");
        }
        return this._propertyCursor;
    }

    public boolean isClosed() {
        return this._nodeCursor == null && this._relationshipScanCursor == null && this._propertyCursor == null;
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            NodeCursor nodeCursorToClose = this._nodeCursor;
            RelationshipScanCursor relationshipScanCursorToClose = this._relationshipScanCursor;
            PropertyCursor propertyCursorToClose = this._propertyCursor;
            this._nodeCursor = null;
            this._relationshipScanCursor = null;
            this._propertyCursor = null;
            IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{nodeCursorToClose, relationshipScanCursorToClose, propertyCursorToClose});
            return;
        }
    }

    public void setKernelTracer(KernelReadTracer tracer) {
        this.nodeCursor().setTracer(tracer);
        this.relationshipScanCursor().setTracer(tracer);
        this.propertyCursor().setTracer(tracer);
    }

    @Override
    public void closeCursors() {
        this.closeInternal();
    }

    @Override
    public void setCursorFactoryAndContext(CursorFactory cursorFactory, CursorContext cursorContext) {
        this.cursorFactory = cursorFactory;
        this.cursorContext = cursorContext;
    }

    private boolean notReturnedToPool(Cursor cursor) {
        Cursor cursor2 = cursor;
        if (cursor2 instanceof TraceableCursor) {
            TraceableCursor traceableCursor = (TraceableCursor)cursor2;
            return !traceableCursor.returnedToPool();
        }
        return true;
    }

    public ExpressionCursors(CursorFactory cursorFactory, CursorContext cursorContext, MemoryTracker memoryTracker) {
        this.cursorFactory = cursorFactory;
        this.cursorContext = cursorContext;
        this.memoryTracker = memoryTracker;
        this._nodeCursor = this.cursorFactory.allocateNodeCursor(this.cursorContext, memoryTracker);
        this._relationshipScanCursor = this.cursorFactory.allocateRelationshipScanCursor(this.cursorContext, memoryTracker);
        this._propertyCursor = this.cursorFactory.allocatePropertyCursor(this.cursorContext, memoryTracker);
    }
}

