/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.memory;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.memory.HeapEstimatorCache;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005Q4A\u0001F\u000b\u0005E!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00035\u0001\u0011\u0005Q\u0007\u0003\u0004:\u0001\u0001\u0006IA\u000f\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001e\t\r\u0015\u0003\u0001\u0015!\u0003G\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u0015\t\u0006\u0001\"\u0011K\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0011\u0015!\u0007\u0001\"\u0011K\u0011\u0015)\u0007\u0001\"\u0011d\u0011\u00151\u0007\u0001\"\u0011d\u0011\u00159\u0007\u0001\"\u0011i\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015q\u0007\u0001\"\u0011p\u0011\u0015\u0019\b\u0001\"\u0011p\u0005m\u0001\u0016M]1mY\u0016d7kY8qK\u0012lU-\\8ssR\u0013\u0018mY6fe*\u0011acF\u0001\u0007[\u0016lwN]=\u000b\u0005aI\u0012a\u0002:v]RLW.\u001a\u0006\u00035m\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00039u\taaY=qQ\u0016\u0014(B\u0001\u0010 \u0003\u0015qWm\u001c\u001bk\u0015\u0005\u0001\u0013aA8sO\u000e\u00011c\u0001\u0001$WA\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0005Y\u0006twMC\u0001)\u0003\u0011Q\u0017M^1\n\u0005)*#AB(cU\u0016\u001cG\u000f\u0005\u0002-]5\tQF\u0003\u0002\u0017;%\u0011q&\f\u0002\u0014'\u000e|\u0007/\u001a3NK6|'/\u001f+sC\u000e\\WM]\u0001\tI\u0016dWmZ1uKB\u0011AFM\u0005\u0003g5\u0012Q\"T3n_JLHK]1dW\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u00027qA\u0011q\u0007A\u0007\u0002+!)\u0001G\u0001a\u0001c\u0005iAO]1dW\u0016$g*\u0019;jm\u0016\u0004\"a\u000f\"\u000e\u0003qR!!\u0010 \u0002\r\u0005$x.\\5d\u0015\ty\u0004)\u0001\u0006d_:\u001cWO\u001d:f]RT!!Q\u0014\u0002\tU$\u0018\u000e\\\u0005\u0003\u0007r\u0012\u0011\u0002T8oO\u0006#G-\u001a:\u0002\u0017Q\u0014\u0018mY6fI\"+\u0017\r]\u0001\n?&\u001c8\t\\8tK\u0012\u0004\"aO$\n\u0005!c$!D!u_6L7MQ8pY\u0016\fg.\u0001\tvg\u0016$g*\u0019;jm\u0016lU-\\8ssR\t1\n\u0005\u0002M\u001f6\tQJC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001VJ\u0001\u0003M_:<\u0017aE3ti&l\u0017\r^3e\u0011\u0016\f\u0007/T3n_JL\u0018AD1mY>\u001c\u0017\r^3OCRLg/\u001a\u000b\u0003)^\u0003\"\u0001T+\n\u0005Yk%\u0001B+oSRDQ\u0001\u0017\u0005A\u0002-\u000bQAY=uKN\fQB]3mK\u0006\u001cXMT1uSZ,GC\u0001+\\\u0011\u0015A\u0016\u00021\u0001L\u00031\tG\u000e\\8dCR,\u0007*Z1q)\t!f\fC\u0003Y\u0015\u0001\u00071*A\u0006sK2,\u0017m]3IK\u0006\u0004HC\u0001+b\u0011\u0015A6\u00021\u0001L\u00035!\bN]8x\u0013\u001a\u001cEn\\:fIR\tA+A\tiK\u0006\u0004\b*[4i/\u0006$XM]'be.\fQA]3tKR\fQa\u00197pg\u0016\facZ3u'\u000e|\u0007/\u001a3NK6|'/\u001f+sC\u000e\\WM\u001d\u000b\u0002c\u0005A\u0011n]\"m_N,G\rF\u0001l!\taE.\u0003\u0002n\u001b\n9!i\\8mK\u0006t\u0017!F4fi\"+\u0017\r]#ti&l\u0017\r^8s\u0007\u0006\u001c\u0007.\u001a\u000b\u0002aB\u0011A&]\u0005\u0003e6\u0012!\u0003S3ba\u0016\u001bH/[7bi>\u00148)Y2iK\u0006Yr-\u001a;TG>\u0004X\r\u001a%fCB,5\u000f^5nCR|'oQ1dQ\u0016\u0004")
public class ParallelScopedMemoryTracker
implements ScopedMemoryTracker {
    private final MemoryTracker delegate;
    private final LongAdder trackedNative;
    private final LongAdder trackedHeap;
    private final AtomicBoolean _isClosed;

    public long usedNativeMemory() {
        return this.trackedNative.sum();
    }

    public long estimatedHeapMemory() {
        return this.trackedHeap.sum();
    }

    public void allocateNative(long bytes) {
        this.throwIfClosed();
        this.delegate.allocateNative(bytes);
        this.trackedNative.add(bytes);
    }

    public void releaseNative(long bytes) {
        this.throwIfClosed();
        this.delegate.releaseNative(bytes);
        this.trackedNative.add(-bytes);
    }

    public void allocateHeap(long bytes) {
        this.throwIfClosed();
        this.delegate.allocateHeap(bytes);
        this.trackedHeap.add(bytes);
    }

    public void releaseHeap(long bytes) {
        this.throwIfClosed();
        this.delegate.releaseHeap(bytes);
        this.trackedHeap.add(-bytes);
    }

    private void throwIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Should not use a closed ScopedMemoryTracker");
        }
    }

    public long heapHighWaterMark() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        long heapUsage;
        long nativeUsage = this.trackedNative.sumThenReset();
        if (nativeUsage != 0L) {
            this.delegate.releaseNative(nativeUsage);
        }
        if ((heapUsage = this.trackedHeap.sumThenReset()) != 0L) {
            this.delegate.releaseHeap(heapUsage);
            return;
        }
    }

    public void close() {
        if (!(this.delegate instanceof ScopedMemoryTracker) || !((ScopedMemoryTracker)this.delegate).isClosed()) {
            this.reset();
        }
        this._isClosed.set(true);
    }

    public MemoryTracker getScopedMemoryTracker() {
        return new ParallelScopedMemoryTracker((MemoryTracker)this);
    }

    public boolean isClosed() {
        return this._isClosed.get();
    }

    public HeapEstimatorCache getHeapEstimatorCache() {
        return this.delegate.getHeapEstimatorCache();
    }

    public HeapEstimatorCache getScopedHeapEstimatorCache() {
        return this.delegate.getScopedHeapEstimatorCache();
    }

    public ParallelScopedMemoryTracker(MemoryTracker delegate) {
        this.delegate = delegate;
        this.trackedNative = new LongAdder();
        this.trackedHeap = new LongAdder();
        this._isClosed = new AtomicBoolean(false);
    }
}

