/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.time.temporal.TemporalAmount;
import org.neo4j.cypher.operations.CypherTypeValueMapper;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

public final class CypherMath {
    private CypherMath() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static AnyValue add(AnyValue lhs, AnyValue rhs) {
        ArrayValue array;
        if (lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue) {
            NumberValue l = (NumberValue)lhs;
            if (rhs instanceof NumberValue) {
                NumberValue r = (NumberValue)rhs;
                try {
                    return l.plus(r);
                }
                catch (ArithmeticException e) {
                    throw org.neo4j.exceptions.ArithmeticException.wrappedArithmeticException((String)(lhs.prettify() + " + " + rhs.prettify()), (String)"+", (Throwable)e);
                }
            }
        }
        if (lhs instanceof ArrayValue) {
            array = (ArrayValue)lhs;
            lhs = VirtualValues.fromArray((ArrayValue)array);
        }
        if (rhs instanceof ArrayValue) {
            array = (ArrayValue)rhs;
            rhs = VirtualValues.fromArray((ArrayValue)array);
        }
        if (lhs instanceof ListValue) {
            ListValue lhsList = (ListValue)lhs;
            if (rhs instanceof ListValue) {
                ListValue rhsList = (ListValue)rhs;
                return lhsList.appendAll(rhsList);
            }
        }
        if (lhs instanceof ListValue) {
            ListValue lhsList = (ListValue)lhs;
            return lhsList.append(rhs);
        }
        if (rhs instanceof ListValue) {
            ListValue rhsList = (ListValue)rhs;
            return rhsList.prepend(lhs);
        }
        if (lhs instanceof TextValue) {
            TextValue lhsText = (TextValue)lhs;
            if (rhs instanceof TextValue) {
                TextValue rhsText = (TextValue)rhs;
                return lhsText.plus(rhsText);
            }
        }
        if (lhs instanceof TextValue) {
            TextValue lhsText = (TextValue)lhs;
            if (rhs instanceof Value) {
                if (!(rhs instanceof TemporalValue || rhs instanceof DurationValue || rhs instanceof PointValue)) {
                    return Values.stringValue((String)(lhsText.stringValue() + rhs.prettyPrint()));
                }
                return Values.stringValue((String)(lhsText.stringValue() + String.valueOf(rhs)));
            }
        } else if (rhs instanceof TextValue) {
            TextValue rhsText = (TextValue)rhs;
            if (lhs instanceof Value) {
                if (!(lhs instanceof TemporalValue || lhs instanceof DurationValue || lhs instanceof PointValue)) {
                    return Values.stringValue((String)(lhs.prettyPrint() + rhsText.stringValue()));
                }
                return Values.stringValue((String)(String.valueOf(lhs) + rhsText.stringValue()));
            }
        }
        if (lhs instanceof TemporalValue) {
            TemporalValue lhsTemporal = (TemporalValue)lhs;
            if (rhs instanceof DurationValue) {
                DurationValue rhsDuration = (DurationValue)rhs;
                return lhsTemporal.plus((TemporalAmount)rhsDuration);
            }
        }
        if (lhs instanceof DurationValue) {
            DurationValue lhsDuration = (DurationValue)lhs;
            if (rhs instanceof TemporalValue) {
                TemporalValue rhsTemporal = (TemporalValue)rhs;
                return rhsTemporal.plus((TemporalAmount)lhsDuration);
            }
            if (rhs instanceof DurationValue) {
                DurationValue rhsDuration = (DurationValue)rhs;
                return lhsDuration.add(rhsDuration);
            }
        }
        if (lhs == null) {
            throw CypherTypeException.addTypeMismatch((String)"null", (String)"NULL", (String)rhs.getTypeName(), (String)"NULL", (String)CypherTypeValueMapper.valueType(rhs));
        }
        throw CypherTypeException.addTypeMismatch((String)lhs.prettyPrint(), (String)lhs.getTypeName(), (String)rhs.getTypeName(), (String)CypherTypeValueMapper.valueType(lhs), (String)CypherTypeValueMapper.valueType(rhs));
    }

    public static AnyValue subtract(AnyValue lhs, AnyValue rhs) {
        if (lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue) {
            NumberValue lhsNumber = (NumberValue)lhs;
            if (rhs instanceof NumberValue) {
                NumberValue rhsNumber = (NumberValue)rhs;
                try {
                    return lhsNumber.minus(rhsNumber);
                }
                catch (ArithmeticException e) {
                    throw org.neo4j.exceptions.ArithmeticException.wrappedArithmeticException((String)(lhs.prettify() + " - " + rhs.prettify()), (String)"-", (Throwable)e);
                }
            }
        }
        if (lhs instanceof TemporalValue) {
            TemporalValue lhsTemporal = (TemporalValue)lhs;
            if (rhs instanceof DurationValue) {
                DurationValue rhsDuration = (DurationValue)rhs;
                return lhsTemporal.minus((TemporalAmount)rhsDuration);
            }
        }
        if (lhs instanceof DurationValue) {
            DurationValue lhsDuration = (DurationValue)lhs;
            if (rhs instanceof DurationValue) {
                DurationValue rhsDuration = (DurationValue)rhs;
                return lhsDuration.sub(rhsDuration);
            }
        }
        if (lhs == null) {
            throw CypherTypeException.subtractTypeMismatch((String)"null", (String)"NULL", (String)rhs.getTypeName(), (String)"NULL", (String)CypherTypeValueMapper.valueType(rhs));
        }
        throw CypherTypeException.subtractTypeMismatch((String)lhs.prettyPrint(), (String)lhs.getTypeName(), (String)rhs.getTypeName(), (String)CypherTypeValueMapper.valueType(lhs), (String)CypherTypeValueMapper.valueType(rhs));
    }

    public static AnyValue multiply(AnyValue lhs, AnyValue rhs) {
        if (lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue) {
            NumberValue lhsNumber = (NumberValue)lhs;
            if (rhs instanceof NumberValue) {
                NumberValue rhsNumber = (NumberValue)rhs;
                try {
                    return lhsNumber.times(rhsNumber);
                }
                catch (ArithmeticException e) {
                    throw org.neo4j.exceptions.ArithmeticException.wrappedArithmeticException((String)(lhs.prettify() + " * " + rhs.prettify()), (String)"*", (Throwable)e);
                }
            }
        }
        if (lhs instanceof DurationValue) {
            DurationValue lhsDuration = (DurationValue)lhs;
            if (rhs instanceof NumberValue) {
                NumberValue rhsNumber = (NumberValue)rhs;
                return lhsDuration.mul(rhsNumber);
            }
        }
        if (rhs instanceof DurationValue) {
            DurationValue rhsDuration = (DurationValue)rhs;
            if (lhs instanceof NumberValue) {
                NumberValue lhsNumber = (NumberValue)lhs;
                return rhsDuration.mul(lhsNumber);
            }
        }
        if (lhs == null) {
            throw CypherTypeException.multiplyTypeMismatch((String)"null", (String)"NULL", (String)rhs.getTypeName(), (String)"NULL", (String)CypherTypeValueMapper.valueType(rhs));
        }
        throw CypherTypeException.multiplyTypeMismatch((String)lhs.prettyPrint(), (String)lhs.getTypeName(), (String)rhs.getTypeName(), (String)CypherTypeValueMapper.valueType(lhs), (String)CypherTypeValueMapper.valueType(rhs));
    }

    private static boolean divideCheckForNull(AnyValue lhs, AnyValue rhs) {
        if (rhs instanceof IntegralValue && rhs.equals((Object)Values.ZERO_INT)) {
            throw org.neo4j.exceptions.ArithmeticException.divisionByZero();
        }
        return lhs == Values.NO_VALUE || rhs == Values.NO_VALUE;
    }

    public static AnyValue divide(AnyValue lhs, AnyValue rhs) {
        if (CypherMath.divideCheckForNull(lhs, rhs)) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue) {
            NumberValue lhsNumber = (NumberValue)lhs;
            if (rhs instanceof NumberValue) {
                NumberValue rhsNumber = (NumberValue)rhs;
                return lhsNumber.divideBy(rhsNumber);
            }
        }
        if (lhs instanceof DurationValue) {
            DurationValue lhsDuration = (DurationValue)lhs;
            if (rhs instanceof NumberValue) {
                NumberValue rhsNumber = (NumberValue)rhs;
                return lhsDuration.div(rhsNumber);
            }
        }
        if (lhs == null) {
            throw CypherTypeException.divideTypeMismatch((String)"null", (String)"NULL", (String)rhs.getTypeName(), (String)"NULL", (String)CypherTypeValueMapper.valueType(rhs));
        }
        throw CypherTypeException.divideTypeMismatch((String)lhs.prettyPrint(), (String)lhs.getTypeName(), (String)rhs.getTypeName(), (String)CypherTypeValueMapper.valueType(lhs), (String)CypherTypeValueMapper.valueType(rhs));
    }

    public static AnyValue modulo(AnyValue lhs, AnyValue rhs) {
        if (lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue) {
            NumberValue lhsNumber = (NumberValue)lhs;
            if (rhs instanceof NumberValue) {
                NumberValue rhsNumber = (NumberValue)rhs;
                try {
                    if (lhsNumber instanceof FloatingPointValue || rhsNumber instanceof FloatingPointValue) {
                        return Values.doubleValue((double)(lhsNumber.doubleValue() % rhsNumber.doubleValue()));
                    }
                    return Values.longValue((long)(lhsNumber.longValue() % rhsNumber.longValue()));
                }
                catch (ArithmeticException e) {
                    throw org.neo4j.exceptions.ArithmeticException.wrappedArithmeticException((String)(lhs.prettify() + " % " + rhs.prettify()), (String)"%", (Throwable)e);
                }
            }
        }
        if (lhs == null) {
            throw CypherTypeException.modulusTypeMismatch((String)"null", (String)"NULL", (String)rhs.getTypeName(), (String)"NULL", (String)CypherTypeValueMapper.valueType(rhs));
        }
        throw CypherTypeException.modulusTypeMismatch((String)lhs.prettyPrint(), (String)lhs.getTypeName(), (String)rhs.getTypeName(), (String)CypherTypeValueMapper.valueType(lhs), (String)CypherTypeValueMapper.valueType(rhs));
    }

    public static AnyValue pow(AnyValue lhs, AnyValue rhs) {
        if (lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue) {
            NumberValue lhsNumber = (NumberValue)lhs;
            if (rhs instanceof NumberValue) {
                NumberValue rhsNumber = (NumberValue)rhs;
                return Values.doubleValue((double)Math.pow(lhsNumber.doubleValue(), rhsNumber.doubleValue()));
            }
        }
        if (lhs == null) {
            throw CypherTypeException.powerTypeMismatch((String)"null", (String)"NULL", (String)rhs.getTypeName(), (String)"NULL", (String)CypherTypeValueMapper.valueType(rhs));
        }
        throw CypherTypeException.powerTypeMismatch((String)lhs.prettyPrint(), (String)lhs.getTypeName(), (String)rhs.getTypeName(), (String)CypherTypeValueMapper.valueType(lhs), (String)CypherTypeValueMapper.valueType(rhs));
    }
}

