/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.List;
import org.neo4j.cypher.operations.CypherTypeValueMapper;
import org.neo4j.exceptions.ArithmeticException;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.storable.VectorValue;

final class VectorUtils {
    private VectorUtils() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    static VectorValue int8Vector(SequenceValue vectorSequence) {
        if (vectorSequence instanceof ByteArray) {
            ByteArray bytes = (ByteArray)vectorSequence;
            return Values.int8Vector((byte[])bytes.asObjectCopy());
        }
        int index = 0;
        int length = vectorSequence.intSize();
        byte[] values = new byte[length];
        for (AnyValue value : vectorSequence) {
            if (value instanceof NumberValue) {
                NumberValue number = (NumberValue)value;
                values[index++] = VectorUtils.safeCastToByte(number.longValue());
                continue;
            }
            throw VectorUtils.invalidVectorType(value);
        }
        return Values.int8Vector((byte[])values);
    }

    static VectorValue int16Vector(SequenceValue vectorSequence) {
        if (vectorSequence instanceof ShortArray) {
            ShortArray shorts = (ShortArray)vectorSequence;
            return Values.int16Vector((short[])shorts.asObjectCopy());
        }
        int index = 0;
        int length = vectorSequence.intSize();
        short[] values = new short[length];
        for (AnyValue value : vectorSequence) {
            if (value instanceof NumberValue) {
                NumberValue number = (NumberValue)value;
                values[index++] = VectorUtils.safeCastToShort(number.longValue());
                continue;
            }
            throw VectorUtils.invalidVectorType(value);
        }
        return Values.int16Vector((short[])values);
    }

    static VectorValue int32Vector(SequenceValue vectorSequence) {
        if (vectorSequence instanceof IntArray) {
            IntArray ints = (IntArray)vectorSequence;
            return Values.int32Vector((int[])ints.asObjectCopy());
        }
        int index = 0;
        int length = vectorSequence.intSize();
        int[] values = new int[length];
        for (AnyValue value : vectorSequence) {
            if (value instanceof NumberValue) {
                NumberValue number = (NumberValue)value;
                values[index++] = VectorUtils.safeCastToInt(number.longValue());
                continue;
            }
            throw VectorUtils.invalidVectorType(value);
        }
        return Values.int32Vector((int[])values);
    }

    static VectorValue int64Vector(SequenceValue vectorSequence) {
        if (vectorSequence instanceof LongArray) {
            LongArray longs = (LongArray)vectorSequence;
            return Values.int64Vector((long[])longs.asObjectCopy());
        }
        int index = 0;
        int length = vectorSequence.intSize();
        long[] values = new long[length];
        for (AnyValue value : vectorSequence) {
            if (value instanceof FloatingPointValue) {
                FloatingPointValue fp = (FloatingPointValue)value;
                values[index++] = VectorUtils.safeCastToLong(fp.doubleValue());
                continue;
            }
            if (value instanceof NumberValue) {
                NumberValue number = (NumberValue)value;
                values[index++] = number.longValue();
                continue;
            }
            throw VectorUtils.invalidVectorType(value);
        }
        return Values.int64Vector((long[])values);
    }

    static VectorValue float32Vector(SequenceValue vectorSequence) {
        int index = 0;
        int length = vectorSequence.intSize();
        float[] values = new float[length];
        for (AnyValue value : vectorSequence) {
            if (value instanceof NumberValue) {
                NumberValue numberValue = (NumberValue)value;
                values[index++] = numberValue.floatValue();
                continue;
            }
            throw VectorUtils.invalidVectorType(value);
        }
        return Values.float32Vector((float[])values);
    }

    static VectorValue float64Vector(SequenceValue vectorSequence) {
        int index = 0;
        int length = vectorSequence.intSize();
        double[] values = new double[length];
        for (AnyValue value : vectorSequence) {
            if (value instanceof NumberValue) {
                NumberValue numberValue = (NumberValue)value;
                values[index++] = numberValue.doubleValue();
                continue;
            }
            throw VectorUtils.invalidVectorType(value);
        }
        return Values.float64Vector((double[])values);
    }

    static byte safeCastToByte(long value) {
        if (value < -128L || value > 127L) {
            throw ArithmeticException.numericValueOutOfRange((String)String.valueOf(value), (String)"vector()");
        }
        return (byte)value;
    }

    static short safeCastToShort(long value) {
        if (value < -32768L || value > 32767L) {
            throw ArithmeticException.numericValueOutOfRange((String)String.valueOf(value), (String)"vector()");
        }
        return (short)value;
    }

    static int safeCastToInt(long value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw ArithmeticException.numericValueOutOfRange((String)String.valueOf(value), (String)"vector()");
        }
        return (int)value;
    }

    static long safeCastToLong(double value) {
        if (value < -9.223372036854776E18 || value > 9.223372036854776E18) {
            throw ArithmeticException.numericValueOutOfRange((String)String.valueOf(value), (String)"vector()");
        }
        return (long)value;
    }

    static Value assertDimension(VectorValue vectorValue, AnyValue dimension) {
        long dimensionValue = VectorUtils.getDimension(dimension);
        if ((long)vectorValue.dimensions() != dimensionValue) {
            throw CypherTypeException.wrongVectorDimension((String)vectorValue.prettyPrint(), (String)vectorValue.nestedTypeName(), (long)dimensionValue, (int)vectorValue.dimensions());
        }
        return vectorValue;
    }

    static long getDimension(AnyValue dimension) {
        if (!(dimension instanceof IntegralValue)) {
            throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'vector()': Expected an integer but got %s", dimension), (String)"vector", (String)dimension.toString(), List.of("INTEGER"), (String)dimension.getTypeName());
        }
        IntegralValue dimensionValue = (IntegralValue)dimension;
        if (dimensionValue.longValue() < 1L || dimensionValue.longValue() > 4096L) {
            throw InvalidArgumentException.argumentOutOfRange((String)"vector", (String)"dimension", (long)1L, (long)4096L, (long)dimensionValue.longValue());
        }
        return dimensionValue.longValue();
    }

    static CypherTypeException invalidVectorType(AnyValue value) {
        return CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'vector()': Expected a NUMBER, got: " + String.valueOf(value)), (String)"vector", (String)value.prettyPrint(), List.of("INTEGER", "FLOAT"), (String)CypherTypeValueMapper.valueType(value));
    }

    static CypherTypeException invalidVector(AnyValue vector) {
        return CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'vector()': Expected a string or list but got %s", vector), (String)"vector", (String)vector.toString(), List.of("STRING", "LIST<INTEGER | FLOAT>"), (String)vector.getTypeName());
    }
}

