/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.result;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.neo4j.internal.schema.IndexDescriptor;

public interface OperatorProfile {
    public static final long NO_DATA = -1L;
    public static final OperatorProfile NONE = new ConstOperatorProfile(-1L);
    public static final OperatorProfile ZERO = new ConstOperatorProfile(0L);

    public long time();

    public long dbHits();

    public long rows();

    public long pageCacheHits();

    public long pageCacheMisses();

    public long maxAllocatedMemory();

    public IndexDescriptor[] indexesUsed();

    public int[] indexUseCount();

    public static int hashCode(OperatorProfile self) {
        return Objects.hash(Arrays.hashCode(new long[]{self.time(), self.dbHits(), self.rows(), self.pageCacheHits(), self.pageCacheMisses(), self.maxAllocatedMemory()}), Arrays.hashCode(self.indexesUsed()), Arrays.hashCode(self.indexUseCount()));
    }

    public static boolean equals(OperatorProfile self, Object o) {
        if (self == o) {
            return true;
        }
        if (!(o instanceof OperatorProfile)) {
            return false;
        }
        OperatorProfile that = (OperatorProfile)o;
        return self.time() == that.time() && self.dbHits() == that.dbHits() && self.rows() == that.rows() && self.pageCacheHits() == that.pageCacheHits() && self.pageCacheMisses() == that.pageCacheMisses() && self.maxAllocatedMemory() == that.maxAllocatedMemory() && Arrays.equals(self.indexesUsed(), that.indexesUsed()) && Arrays.equals(self.indexUseCount(), that.indexUseCount());
    }

    public static String toString(OperatorProfile self) {
        return String.format("Operator Profile { time: %d, dbHits: %d, rows: %d, page cache hits: %d, page cache misses: %d, max allocated: %d, indexes used: %s, index use count: %s }", self.time(), self.dbHits(), self.rows(), self.pageCacheHits(), self.pageCacheMisses(), self.maxAllocatedMemory(), Arrays.stream(self.indexesUsed()).map(IndexDescriptor::getName).collect(Collectors.joining(",")), Arrays.stream(self.indexUseCount()).mapToObj(String::valueOf).collect(Collectors.joining(",")));
    }

    public static class ConstOperatorProfile
    implements OperatorProfile {
        private final long time;
        private final long dbHits;
        private final long rows;
        private final long pageCacheHits;
        private final long pageCacheMisses;
        private final long maxAllocatedMemory;
        private final IndexDescriptor[] indexesUsed = new IndexDescriptor[0];
        private final int[] indexUseCount = new int[0];

        ConstOperatorProfile(long value) {
            this(value, value, value, value, value, value);
        }

        public ConstOperatorProfile(long time, long dbHits, long rows, long pageCacheHits, long pageCacheMisses, long maxAllocatedMemory) {
            this.time = time;
            this.dbHits = dbHits;
            this.rows = rows;
            this.pageCacheHits = pageCacheHits;
            this.pageCacheMisses = pageCacheMisses;
            this.maxAllocatedMemory = maxAllocatedMemory;
        }

        @Override
        public long time() {
            return this.time;
        }

        @Override
        public long dbHits() {
            return this.dbHits;
        }

        @Override
        public long rows() {
            return this.rows;
        }

        @Override
        public long pageCacheHits() {
            return this.pageCacheHits;
        }

        @Override
        public long pageCacheMisses() {
            return this.pageCacheMisses;
        }

        @Override
        public long maxAllocatedMemory() {
            return this.maxAllocatedMemory;
        }

        @Override
        public IndexDescriptor[] indexesUsed() {
            return this.indexesUsed;
        }

        @Override
        public int[] indexUseCount() {
            return this.indexUseCount;
        }

        public int hashCode() {
            return OperatorProfile.hashCode(this);
        }

        public boolean equals(Object o) {
            return OperatorProfile.equals(this, o);
        }

        public String toString() {
            return OperatorProfile.toString(this);
        }
    }
}

