/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalEntities;
import org.neo4j.internal.kernel.api.helpers.traversal.BFS;
import org.neo4j.internal.kernel.api.helpers.traversal.PathTraceStep;
import org.neo4j.internal.kernel.api.helpers.traversal.PathTracingIterator;
import org.neo4j.internal.kernel.api.helpers.traversal.ReversedRelTraversalEntitiesPredicate;
import org.neo4j.internal.kernel.api.helpers.traversal.ShortestPathBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.State;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.virtual.PathReference;

abstract class BiDirectionalBFSImpl<STEPS>
implements ShortestPathBFS {
    final int maxDepth;
    final BFS<STEPS> sourceBFS;
    final BFS<STEPS> targetBFS;
    State algorithmState;
    private final boolean allowZeroLength;

    BiDirectionalBFSImpl(long sourceNodeId, long targetNodeId, int[] types, Direction direction, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, boolean allowZeroLength) {
        this.maxDepth = maxDepth;
        this.allowZeroLength = allowZeroLength;
        this.sourceBFS = this.createBFS(sourceNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter);
        this.targetBFS = this.createBFS(targetNodeId, types, direction.reverse(), read, nodeCursor, relCursor, memoryTracker, nodeFilter, new ReversedRelTraversalEntitiesPredicate(relFilter));
        this.sourceBFS.setOther(this.targetBFS);
        this.targetBFS.setOther(this.sourceBFS);
    }

    abstract BFS<STEPS> createBFS(long var1, int[] var3, Direction var4, Read var5, NodeCursor var6, RelationshipTraversalCursor var7, MemoryTracker var8, LongPredicate var9, Predicate<RelationshipTraversalEntities> var10);

    void resetForNewRow(long sourceNodeId, long targetNodeId, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter) {
        this.sourceBFS.resetWithStartNode(sourceNodeId, nodeCursor, relCursor, nodeFilter, relFilter);
        this.targetBFS.resetWithStartNode(targetNodeId, nodeCursor, relCursor, nodeFilter, new ReversedRelTraversalEntitiesPredicate(relFilter));
        this.algorithmState = State.CAN_SEARCH_FOR_INTERSECTION;
    }

    abstract Iterator<PathReference> pathTracingIterator(LongIterator var1);

    @Override
    public Iterator<PathReference> shortestPathIterator() {
        assert (this.algorithmState == State.CAN_SEARCH_FOR_INTERSECTION);
        if (this.sourceBFS.startNodeId == this.targetBFS.startNodeId && this.allowZeroLength) {
            return this.pathTracingIterator(PrimitiveLongCollections.single((long)this.sourceBFS.startNodeId));
        }
        BFS<STEPS> bfsToAdvance = null;
        int depth = 0;
        while (this.algorithmState == State.CAN_SEARCH_FOR_INTERSECTION) {
            if (depth++ == this.maxDepth) {
                this.algorithmState = State.REACHED_MAX_DEPTH;
                continue;
            }
            bfsToAdvance = this.pickBFSWithSmallestCurrentLevelSet(this.sourceBFS, this.targetBFS);
            this.algorithmState = bfsToAdvance.searchForIntersectionInNextLevel();
        }
        if (this.algorithmState == State.THERE_IS_NO_INTERSECTION || this.algorithmState == State.REACHED_MAX_DEPTH) {
            return Collections.emptyIterator();
        }
        return this.pathTracingIterator(bfsToAdvance.intersectionIterator());
    }

    private BFS<STEPS> pickBFSWithSmallestCurrentLevelSet(BFS<STEPS> bfs1, BFS<STEPS> bfs2) {
        return bfs1.currentLevel.size() > bfs2.currentLevel.size() ? bfs2 : bfs1;
    }

    @Override
    public void close() {
        this.sourceBFS.close();
        this.targetBFS.close();
    }

    @Override
    public void setTracer(KernelReadTracer tracer) {
        this.sourceBFS.setTracer(tracer);
        this.targetBFS.setTracer(tracer);
    }

    static class EagerMultiPathBiDirectionalBFS
    extends BiDirectionalBFSImpl<HeapTrackingArrayList<PathTraceStep>> {
        EagerMultiPathBiDirectionalBFS(long sourceNodeId, long targetNodeId, int[] types, Direction direction, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, boolean allowZeroLength) {
            super(sourceNodeId, targetNodeId, types, direction, maxDepth, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, allowZeroLength);
        }

        @Override
        BFS<HeapTrackingArrayList<PathTraceStep>> createBFS(long sourceNodeId, int[] types, Direction direction, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter) {
            return new BFS.EagerBFS(sourceNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter);
        }

        @Override
        Iterator<PathReference> pathTracingIterator(LongIterator iterator) {
            return PathTracingIterator.multiePathTracingIterator(iterator, this.sourceBFS.currentDepth, this.targetBFS.currentDepth, this.sourceBFS.pathTraceData, this.targetBFS.pathTraceData);
        }
    }

    static class LazyMultiPathBiDirectionalBFS
    extends BiDirectionalBFSImpl<HeapTrackingArrayList<PathTraceStep>> {
        LazyMultiPathBiDirectionalBFS(long sourceNodeId, long targetNodeId, int[] types, Direction direction, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, boolean allowZeroLength) {
            super(sourceNodeId, targetNodeId, types, direction, maxDepth, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, allowZeroLength);
        }

        @Override
        Iterator<PathReference> pathTracingIterator(LongIterator iterator) {
            return PathTracingIterator.multiePathTracingIterator(iterator, this.sourceBFS.currentDepth, this.targetBFS.currentDepth, this.sourceBFS.pathTraceData, this.targetBFS.pathTraceData);
        }

        @Override
        BFS<HeapTrackingArrayList<PathTraceStep>> createBFS(long sourceNodeId, int[] types, Direction direction, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter) {
            return new BFS.LazyBFS(sourceNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter);
        }
    }

    static class SinglePathBiDirectionalBFS
    extends BiDirectionalBFSImpl<PathTraceStep> {
        SinglePathBiDirectionalBFS(long sourceNodeId, long targetNodeId, int[] types, Direction direction, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, boolean allowZeroLength) {
            super(sourceNodeId, targetNodeId, types, direction, maxDepth, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, allowZeroLength);
        }

        @Override
        BFS<PathTraceStep> createBFS(long sourceNodeId, int[] types, Direction direction, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter) {
            return new BFS.SinglePathBFS(sourceNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter);
        }

        @Override
        Iterator<PathReference> pathTracingIterator(LongIterator iterator) {
            return PathTracingIterator.singlePathTracingIterator(iterator, this.sourceBFS.currentDepth, this.targetBFS.currentDepth, this.sourceBFS.pathTraceData, this.targetBFS.pathTraceData);
        }
    }
}

