/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal;

import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalEntities;
import org.neo4j.internal.kernel.api.helpers.traversal.BiDirectionalBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.ShortestPathBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.shortestloop.UndirectedMultiShortestLoopCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.shortestloop.UndirectedShortestLoopWalkCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.shortestloop.UndirectedSingleShortestLoopCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.shortestloop.UndirectedSingleShortestLoopWalkCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.shortestloop.ZeroLengthShortestCursor;
import org.neo4j.memory.MemoryTracker;

public class ShortestPathBFSFactory {
    public static ShortestPathBFS create(long sourceNodeId, long targetNodeId, int[] types, Direction direction, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, boolean stopAsapAtIntersect, boolean allowZeroLength, boolean needOnlyOnePath, boolean walkTraversalMode, ShortestPathBFS oldBfs) {
        if (sourceNodeId == targetNodeId && direction == Direction.BOTH) {
            if (oldBfs != null) {
                oldBfs.close();
            }
            if (allowZeroLength) {
                return new ZeroLengthShortestCursor(sourceNodeId);
            }
            if (walkTraversalMode && needOnlyOnePath) {
                return new UndirectedSingleShortestLoopWalkCursor(sourceNodeId, types, maxDepth, read, nodeCursor, relCursor, nodeFilter, relFilter, memoryTracker);
            }
            if (walkTraversalMode) {
                return new UndirectedShortestLoopWalkCursor(sourceNodeId, types, maxDepth, read, nodeCursor, relCursor, nodeFilter, relFilter, memoryTracker);
            }
            if (needOnlyOnePath) {
                return new UndirectedSingleShortestLoopCursor(sourceNodeId, types, maxDepth, read, nodeCursor, relCursor, nodeFilter, relFilter, memoryTracker);
            }
            return new UndirectedMultiShortestLoopCursor(sourceNodeId, types, maxDepth, read, nodeCursor, relCursor, nodeFilter, relFilter, memoryTracker);
        }
        if (oldBfs != null && oldBfs instanceof BiDirectionalBFS) {
            BiDirectionalBFS bfs = (BiDirectionalBFS)oldBfs;
            bfs.resetForNewRow(sourceNodeId, targetNodeId, nodeCursor, relCursor, nodeFilter, relFilter);
            return bfs;
        }
        return BiDirectionalBFS.newEmptyBiDirectionalBFS(sourceNodeId, targetNodeId, types, direction, maxDepth, stopAsapAtIntersect, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, needOnlyOnePath, allowZeroLength);
    }
}

