/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.shortestloop;

import java.util.Iterator;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.lang.AutoCloseablePlus;
import org.neo4j.values.virtual.PathReference;

public abstract class UndirectedShortestLoopCursor
extends DefaultCloseListenable
implements AutoCloseablePlus {
    public abstract boolean next();

    public abstract PathReference path();

    public abstract Iterator<PathReference> shortestPathIterator();

    static enum Loop {
        LOOP_IN_CURRENT_FRONTIER{

            @Override
            int loopLength(int depth) {
                return 2 * (depth + 1) - 1;
            }
        }
        ,
        LOOP_IN_NEXT_FRONTIER{

            @Override
            int loopLength(int depth) {
                return 2 * (depth + 1);
            }
        }
        ,
        ALREADY_SEEN{

            @Override
            int loopLength(int depth) {
                throw new IllegalStateException("There is no loop");
            }
        }
        ,
        NO_LOOP{

            @Override
            int loopLength(int depth) {
                throw new IllegalStateException("There is no loop");
            }
        };


        abstract int loopLength(int var1);
    }

    record Trace(long relId, long prevNode) {
    }
}

