/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.shortestloop;

import java.util.Iterator;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingLongArrayList;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalEntities;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.internal.kernel.api.helpers.traversal.ShortestPathBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.shortestloop.UndirectedShortestLoopCursor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.virtual.PathReference;
import org.neo4j.values.virtual.VirtualValues;

public final class UndirectedSingleShortestLoopWalkCursor
extends UndirectedShortestLoopCursor
implements ShortestPathBFS {
    private final long startNode;
    private final Read read;
    private final NodeCursor nodeCursor;
    private final RelationshipTraversalCursor relCursor;
    private final int[] types;
    private final LongPredicate nodeFilter;
    private final Predicate<RelationshipTraversalEntities> relationshipsFilter;
    private final HeapTrackingLongObjectHashMap<HeapTrackingLongArrayList> pathTracing;
    private PathReference path;
    private final MemoryTracker memoryTracker;
    private final int maxDepth;
    private boolean closed;

    public UndirectedSingleShortestLoopWalkCursor(long startNode, int[] types, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relationshipFilter, MemoryTracker memoryTracker) {
        this.startNode = startNode;
        this.read = read;
        this.types = types;
        this.maxDepth = maxDepth;
        this.nodeCursor = nodeCursor;
        this.relCursor = relCursor;
        this.nodeFilter = nodeFilter;
        this.relationshipsFilter = relationshipFilter;
        this.pathTracing = HeapTrackingCollections.newLongObjectMap((MemoryTracker)memoryTracker);
        this.path = null;
        this.memoryTracker = memoryTracker;
        this.closed = false;
    }

    @Override
    public boolean next() {
        if (this.path == null) {
            return this.search();
        }
        return false;
    }

    public boolean search() {
        this.read.singleNode(this.startNode, this.nodeCursor);
        if (!this.nodeCursor.next()) {
            throw EntityNotFoundException.nodeUnexpectedlyDeleted((long)this.startNode);
        }
        RelationshipTraversalCursor selectionCursor = RelationshipSelections.allCursor((RelationshipTraversalCursor)this.relCursor, (NodeCursor)this.nodeCursor, (int[])this.types);
        while (selectionCursor.next()) {
            long foundNode;
            if (!this.relationshipsFilter.test((RelationshipTraversalEntities)selectionCursor) || !this.nodeFilter.test(foundNode = selectionCursor.otherNodeReference()) || this.maxDepth == 1 && foundNode != this.startNode) continue;
            if (foundNode == this.startNode) {
                HeapTrackingLongArrayList traces = HeapTrackingLongArrayList.newLongArrayList((MemoryTracker)this.memoryTracker);
                traces.add(selectionCursor.reference());
                this.pathTracing.put(this.startNode, (Object)traces);
                this.path = VirtualValues.pathReference((long[])new long[]{this.startNode, this.startNode}, (long[])new long[]{selectionCursor.reference()});
            } else {
                HeapTrackingLongArrayList traces = HeapTrackingLongArrayList.newLongArrayList((MemoryTracker)this.memoryTracker);
                traces.add(selectionCursor.reference());
                this.pathTracing.put(foundNode, (Object)traces);
                this.path = VirtualValues.pathReference((long[])new long[]{this.startNode, foundNode, this.startNode}, (long[])new long[]{selectionCursor.reference(), selectionCursor.reference()});
            }
            return true;
        }
        return false;
    }

    @Override
    public PathReference path() {
        return this.path;
    }

    public void closeInternal() {
        if (!this.closed) {
            for (long key : this.pathTracing.keySet().toArray()) {
                ((HeapTrackingLongArrayList)this.pathTracing.get(key)).close();
            }
            this.pathTracing.close();
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Iterator<PathReference> shortestPathIterator() {
        this.search();
        return Iterators.iterator((Object)this.path);
    }

    @Override
    public void setTracer(KernelReadTracer tracer) {
        if (this.nodeCursor != null) {
            this.nodeCursor.setTracer(tracer);
        }
        if (this.relCursor != null) {
            this.relCursor.setTracer(tracer);
        }
    }
}

