/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.io.pagecache.PageCursor;

class CountsHeader {
    CountsHeader() {
    }

    static Reader reader() {
        return new Reader();
    }

    static Writer writer(LongSupplier highestGapFreeTxIdSupplier) {
        return new Writer(highestGapFreeTxIdSupplier);
    }

    static class Reader
    implements Header.Reader {
        private boolean wasRead;
        private long highestGapFreeTxId;

        Reader() {
        }

        public void read(ByteBuffer headerBytes) {
            this.wasRead = true;
            this.highestGapFreeTxId = headerBytes.getLong();
        }

        boolean wasRead() {
            return this.wasRead;
        }

        long highestGapFreeTxId() {
            return this.highestGapFreeTxId;
        }
    }

    static class Writer
    implements Consumer<PageCursor> {
        private final LongSupplier highestGapFreeTxIdSupplier;

        Writer(LongSupplier highestGapFreeTxIdSupplier) {
            this.highestGapFreeTxIdSupplier = highestGapFreeTxIdSupplier;
        }

        @Override
        public void accept(PageCursor cursor) {
            cursor.putLong(this.highestGapFreeTxIdSupplier.getAsLong());
        }
    }
}

