/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.token;

import java.util.List;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.CreatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.token.api.TokensLoader;

public record TokenHolders(TokenHolder propertyKeyTokens, TokenHolder labelTokens, TokenHolder relationshipTypeTokens) implements TokenNameLookup
{
    public void setInitialTokens(TokensLoader loader, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        this.propertyKeyTokens().setInitialTokens(loader.getPropertyKeyTokens(storeCursors, memoryTracker));
        this.labelTokens().setInitialTokens(loader.getLabelTokens(storeCursors, memoryTracker));
        this.relationshipTypeTokens().setInitialTokens(loader.getRelationshipTypeTokens(storeCursors, memoryTracker));
    }

    public String labelGetName(int labelId) {
        try {
            return this.labelTokens().getTokenById(labelId).name();
        }
        catch (TokenNotFoundException e) {
            return "[no such label: " + labelId + "]";
        }
    }

    public String relationshipTypeGetName(int relationshipTypeId) {
        try {
            return this.relationshipTypeTokens().getTokenById(relationshipTypeId).name();
        }
        catch (TokenNotFoundException e) {
            return "[no such relationship type: " + relationshipTypeId + "]";
        }
    }

    public String propertyKeyGetName(int propertyKeyId) {
        try {
            return this.propertyKeyTokens().getTokenById(propertyKeyId).name();
        }
        catch (TokenNotFoundException e) {
            return "[no such property key: " + propertyKeyId + "]";
        }
    }

    public TokenNameLookup lookupWithIds() {
        return new TokenNameLookup(){

            public String labelGetName(int labelId) {
                return TokenHolders.this.labelGetName(labelId) + "[" + labelId + "]";
            }

            public String relationshipTypeGetName(int relationshipTypeId) {
                return TokenHolders.this.relationshipTypeGetName(relationshipTypeId) + "[" + relationshipTypeId + "]";
            }

            public String propertyKeyGetName(int propertyKeyId) {
                return TokenHolders.this.propertyKeyGetName(propertyKeyId) + "[" + propertyKeyId + "]";
            }
        };
    }

    public int labelForName(String label) {
        return this.labelTokens().getIdByName(label);
    }

    public int[] labelsForNames(List<String> labels) {
        return TokenHolders.idsForNames(this.labelTokens(), labels);
    }

    public int relationshipForName(String relType) {
        return this.relationshipTypeTokens().getIdByName(relType);
    }

    public int[] relationshipsForNames(List<String> relTypes) {
        return TokenHolders.idsForNames(this.relationshipTypeTokens(), relTypes);
    }

    public int propertyForName(String property) {
        return this.propertyKeyTokens().getIdByName(property);
    }

    public int[] propertiesForName(List<String> properties) {
        return TokenHolders.idsForNames(this.propertyKeyTokens(), properties);
    }

    public static TokenHolders readOnlyTokenHolders(TokensLoader loader, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        TokenHolders tokenHolders = new TokenHolders(new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "PropertyKey"), new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "Label"), new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "RelationshipType"));
        tokenHolders.setInitialTokens(loader, storeCursors, memoryTracker);
        return tokenHolders;
    }

    private static int[] idsForNames(TokenHolder holder, List<String> tokens) {
        int[] ids = new int[tokens.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = holder.getIdByName(tokens.get(i));
        }
        return ids;
    }
}

