/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.token.api;

import java.util.StringJoiner;
import java.util.function.IntFunction;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;

public final class TokenIdPrettyPrinter {
    private TokenIdPrettyPrinter() {
    }

    public static String label(int id) {
        return id == -1 ? "" : ":label=" + id;
    }

    public static String propertyKey(int id) {
        return id == -1 ? "" : ":propertyKey=" + id;
    }

    public static String relationshipType(int id) {
        return id == -1 ? "" : "[:type=" + id + "]";
    }

    public static String niceQuotedProperties(TokenNameLookup tokenNameLookup, int ... propertyIds) {
        return TokenIdPrettyPrinter.niceProperties(tokenNameLookup, true, '(', ')', propertyIds);
    }

    public static String niceProperties(TokenNameLookup tokenNameLookup, int ... propertyIds) {
        return TokenIdPrettyPrinter.niceProperties(tokenNameLookup, false, '{', '}', propertyIds);
    }

    private static String niceProperties(TokenNameLookup tokenNameLookup, boolean alwaysQuote, char prefix, char suffix, int ... propertyIds) {
        StringBuilder out = new StringBuilder();
        out.append(prefix);
        TokenIdPrettyPrinter.format(out, "", ", ", alwaysQuote, arg_0 -> ((TokenNameLookup)tokenNameLookup).propertyKeyGetName(arg_0), propertyIds);
        out.append(suffix);
        return out.toString();
    }

    public static String niceEntityTokens(TokenNameLookup tokenNameLookup, EntityType entityType, int ... tokenIds) {
        IntFunction<String> lookup = entityType == EntityType.NODE ? arg_0 -> ((TokenNameLookup)tokenNameLookup).labelGetName(arg_0) : arg_0 -> ((TokenNameLookup)tokenNameLookup).relationshipTypeGetName(arg_0);
        StringJoiner entityJoiner = new StringJoiner("|", ":", "");
        entityJoiner.setEmptyValue("");
        for (int id : tokenIds) {
            Object name = lookup.apply(id);
            if (((String)name).contains(":")) {
                name = "`" + (String)name + "`";
            }
            entityJoiner.add((CharSequence)name);
        }
        return entityJoiner.toString();
    }

    public static void format(StringBuilder out, String prefix, String separator, boolean alwaysQuote, IntFunction<String> lookup, int ... ids) {
        for (int id : ids) {
            String name = lookup.apply(id);
            out.append(prefix);
            if (alwaysQuote || name.contains(":")) {
                out.append('`').append(name).append('`');
            } else {
                out.append(name);
            }
            out.append(separator);
        }
        if (ids.length > 0) {
            out.setLength(out.length() - separator.length());
        }
    }
}

