/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.batchimport.api.IndexImporterFactory;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.format.Capability;
import org.neo4j.storageengine.api.format.CapabilityType;
import org.neo4j.storageengine.api.format.MultiVersionedIndexesCompatibility;
import org.neo4j.storageengine.migration.AbstractStoreMigrationParticipant;

public class SchemaIndexMigrator
extends AbstractStoreMigrationParticipant {
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final PageCacheTracer pageCacheTracer;
    private final IndexDirectoryStructure indexDirectoryStructure;
    private final StorageEngineFactory storageEngineFactory;
    private final CursorContextFactory contextFactory;
    private boolean deleteRelationshipIndexes;
    private boolean deleteAllIndexes;

    public SchemaIndexMigrator(String name, FileSystemAbstraction fileSystem, PageCache pageCache, PageCacheTracer pageCacheTracer, IndexDirectoryStructure indexDirectoryStructure, StorageEngineFactory storageEngineFactory, CursorContextFactory contextFactory) {
        super(name + " indexes");
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.pageCacheTracer = pageCacheTracer;
        this.indexDirectoryStructure = indexDirectoryStructure;
        this.storageEngineFactory = storageEngineFactory;
        this.contextFactory = contextFactory;
    }

    public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressListener progressListener, StoreVersion fromVersion, StoreVersion toVersion, IndexImporterFactory indexImporterFactory, LogTailMetadata tailMetadata) {
        this.deleteAllIndexes = this.differentMultiVersionCapabilities(toVersion, fromVersion);
        this.deleteRelationshipIndexes = !fromVersion.hasCompatibleCapabilities(toVersion, CapabilityType.FORMAT);
    }

    public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, StoreVersion versionToUpgradeFrom, StoreVersion versionToMigrateTo, MemoryTracker memoryTracker) throws IOException {
        Path schemaIndexDirectory = this.indexDirectoryStructure.rootDirectory();
        if (schemaIndexDirectory != null) {
            if (this.deleteAllIndexes) {
                this.fileSystem.deleteRecursively(schemaIndexDirectory);
            } else if (this.deleteRelationshipIndexes) {
                this.deleteRelationshipIndexes(directoryLayout, memoryTracker);
            }
        }
    }

    public void cleanup(DatabaseLayout migrationLayout) {
    }

    private boolean differentMultiVersionCapabilities(StoreVersion toVersion, StoreVersion fromVersion) {
        return toVersion.hasCapability((Capability)MultiVersionedIndexesCompatibility.MULTI_VERSION_INDEXES) ^ fromVersion.hasCapability((Capability)MultiVersionedIndexesCompatibility.MULTI_VERSION_INDEXES);
    }

    private void deleteRelationshipIndexes(DatabaseLayout databaseLayout, MemoryTracker memoryTracker) throws IOException {
        for (SchemaRule schemaRule : this.storageEngineFactory.loadSchemaRules(this.fileSystem, this.pageCache, this.pageCacheTracer, Config.defaults(), databaseLayout, false, r -> r, this.contextFactory, memoryTracker)) {
            if (schemaRule.schema().entityType() != EntityType.RELATIONSHIP) continue;
            this.fileSystem.deleteRecursively(this.indexDirectoryStructure.directoryForIndex(schemaRule.getId()));
        }
    }
}

