/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v10;

import java.lang.runtime.SwitchBootstraps;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Objects;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10Document;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10ReusableDocWithId;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10TrigramTokenStream;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10ValueFields;
import org.neo4j.kernel.api.impl.schema.vector.Neo4jVectorSimilarityFunction;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class Lucene10DocumentsFactory
implements LuceneDocumentsFactory {
    public static final LuceneDocumentsFactory INSTANCE = new Lucene10DocumentsFactory();

    @Override
    public LuceneDocument newDocument() {
        return new Lucene10Document();
    }

    @Override
    public LuceneDocument reusableTextDocument(long id, Value ... values) {
        return Lucene10ReusableDocWithId.reusableTextDocument(id, values);
    }

    @Override
    public LuceneDocument reusableFulltextDocument(long id, String[] propertyNames, Value[] values) {
        return Lucene10ReusableDocWithId.reusableFulltextDocument(id, propertyNames, values);
    }

    @Override
    public LuceneDocument createTrigramDocument(long id, Value value) {
        Lucene10Document document = new Lucene10Document();
        document.addStringField("id", Long.toString(id), false);
        document.addNumericField("id", id);
        if (value.valueGroup() == ValueGroup.TEXT) {
            Lucene10TrigramTokenStream tokenStream = new Lucene10TrigramTokenStream(value.asObject().toString());
            TrigramField valueField = new TrigramField("0", tokenStream);
            document.document.add((IndexableField)valueField);
        }
        return document;
    }

    @Override
    public LuceneDocument createVectorDocument(VectorDocumentStructure vectorDocumentStructure, long id, Neo4jVectorSimilarityFunction similarityFunction, Value[] values) {
        Preconditions.checkArgument((values != null && values.length >= 1 ? 1 : 0) != 0, (String)"%s vector document has no values", (Object[])new Object[]{this.getClass().getSimpleName()});
        float[] vector = LuceneDocumentsFactory.maybeVectorFromValues(values, similarityFunction);
        if (vector == null) {
            return null;
        }
        Lucene10Document document = new Lucene10Document();
        document.addStringField("id", Long.toString(id), false);
        document.addNumericField("id", id);
        document.addKnnFloatVectorField(vectorDocumentStructure.vectorValueKeyFor(vector.length), vector, similarityFunction);
        for (int i = 1; i < values.length; ++i) {
            Lucene10ValueFields.BooleanField field;
            Value value;
            Value value2 = values[i];
            Objects.requireNonNull(value2);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanValue.class, ByteValue.class, ShortValue.class, IntValue.class, LongValue.class, FloatValue.class, DoubleValue.class, TextValue.class, TemporalValue.class}, (Object)value, n)) {
                case 0: {
                    BooleanValue bv = (BooleanValue)value;
                    Field field2 = new Lucene10ValueFields.BooleanField(vectorDocumentStructure.booleanValueKeyFor(i), bv.booleanValue());
                    break;
                }
                case 1: {
                    ByteValue bv = (ByteValue)value;
                    Field field2 = new Lucene10ValueFields.SingleLongField(vectorDocumentStructure.integralValueKeyFor(i), bv.intValue());
                    break;
                }
                case 2: {
                    ShortValue sv = (ShortValue)value;
                    Field field2 = new Lucene10ValueFields.SingleLongField(vectorDocumentStructure.integralValueKeyFor(i), sv.intValue());
                    break;
                }
                case 3: {
                    IntValue iv = (IntValue)value;
                    Field field2 = new Lucene10ValueFields.SingleLongField(vectorDocumentStructure.integralValueKeyFor(i), iv.value());
                    break;
                }
                case 4: {
                    LongValue lv = (LongValue)value;
                    Field field2 = new Lucene10ValueFields.SingleLongField(vectorDocumentStructure.integralValueKeyFor(i), lv.value());
                    break;
                }
                case 5: {
                    FloatValue fv = (FloatValue)value;
                    Field field2 = new Lucene10ValueFields.SingleDoubleField(vectorDocumentStructure.floatingValueKeyFor(i), fv.value());
                    break;
                }
                case 6: {
                    DoubleValue dv = (DoubleValue)value;
                    Field field2 = new Lucene10ValueFields.SingleDoubleField(vectorDocumentStructure.floatingValueKeyFor(i), dv.value());
                    break;
                }
                case 7: {
                    TextValue tv = (TextValue)value;
                    Field field2 = new StringField(vectorDocumentStructure.textValueKeyFor(i), tv.stringValue(), Field.Store.NO);
                    break;
                }
                case 8: {
                    TemporalValue tv = (TemporalValue)value;
                    Field field2 = new LongPoint(vectorDocumentStructure.temporalValueKeyFor(i), new long[]{tv.getLong((TemporalField)ChronoField.EPOCH_DAY), tv.getLong((TemporalField)ChronoField.NANO_OF_DAY), tv.getLong((TemporalField)ChronoField.OFFSET_SECONDS)});
                    break;
                }
                default: {
                    Field field2 = field = null;
                }
            }
            if (field == null) continue;
            document.document.add((IndexableField)field);
        }
        return document;
    }

    private static class TrigramField
    extends Field {
        private static final FieldType TYPE = new FieldType();

        private TrigramField(String name, TokenStream tokenStream) {
            super(name, tokenStream, (IndexableFieldType)TYPE);
        }

        static {
            TYPE.setOmitNorms(true);
            TYPE.setIndexOptions(IndexOptions.DOCS);
            TYPE.setTokenized(true);
            TYPE.setStored(false);
            TYPE.freeze();
        }
    }
}

