/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v10;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.neo4j.util.Preconditions;

final class Lucene10ValueFields {
    private Lucene10ValueFields() {
    }

    private static byte[] longToBytes(long value) {
        byte[] data = new byte[8];
        NumericUtils.longToSortableBytes((long)value, (byte[])data, (int)0);
        return data;
    }

    static final class SingleDoubleField
    extends Field {
        private static final FieldType TYPE;

        SingleDoubleField(String name, double value) {
            super(name, (IndexableFieldType)TYPE);
            this.fieldsData = value;
        }

        public BytesRef binaryValue() {
            return new BytesRef(Lucene10ValueFields.longToBytes((Long)this.fieldsData));
        }

        public void setDoubleValue(double value) {
            super.setLongValue(NumericUtils.doubleToSortableLong((double)value));
        }

        public void setLongValue(long value) {
            throw new IllegalArgumentException("cannot change value type from Double to Long");
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + " <" + this.name + ":" + String.valueOf(this.fieldsData) + ">";
        }

        static Query newExactQuery(String field, double value) {
            Preconditions.requireNonNull((Object)field, (String)"field cannot be null");
            byte[] encodedValue = SingleDoubleField.doubleToBytes(value);
            return new PointRangeQuery(field, encodedValue, encodedValue, 1){

                protected String toString(int dimension, byte[] value) {
                    return Double.toString(NumericUtils.sortableLongToDouble((long)NumericUtils.sortableBytesToLong((byte[])value, (int)0)));
                }
            };
        }

        static Query newRangeQuery(String field, double lowerValueInclusive, double upperValueInclusive) {
            Preconditions.requireNonNull((Object)field, (String)"field cannot be null");
            Preconditions.checkArgument((Double.compare(lowerValueInclusive, upperValueInclusive) <= 0 ? 1 : 0) != 0, (String)"upper bound for floating range cannot be lower than lower bound");
            return new PointRangeQuery(field, SingleDoubleField.doubleToBytes(lowerValueInclusive), SingleDoubleField.doubleToBytes(upperValueInclusive), 1){

                protected String toString(int dimension, byte[] value) {
                    return Double.toString(NumericUtils.sortableLongToDouble((long)NumericUtils.sortableBytesToLong((byte[])value, (int)0)));
                }
            };
        }

        private static byte[] doubleToBytes(double value) {
            return Lucene10ValueFields.longToBytes(NumericUtils.doubleToSortableLong((double)value));
        }

        static {
            FieldType type = new FieldType();
            type.setDimensions(1, 8);
            type.freeze();
            TYPE = type;
        }
    }

    static final class SingleLongField
    extends Field {
        private static final FieldType TYPE;

        SingleLongField(String name, long value) {
            super(name, (IndexableFieldType)TYPE);
            this.fieldsData = value;
        }

        public BytesRef binaryValue() {
            return new BytesRef(Lucene10ValueFields.longToBytes((Long)this.fieldsData));
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + " <" + this.name + ":" + String.valueOf(this.fieldsData) + ">";
        }

        static Query newExactQuery(String field, long value) {
            Preconditions.requireNonNull((Object)field, (String)"field cannot be null");
            byte[] encodedValue = Lucene10ValueFields.longToBytes(value);
            return new PointRangeQuery(field, encodedValue, encodedValue, 1){

                protected String toString(int dimension, byte[] value) {
                    return Long.toString(NumericUtils.sortableBytesToLong((byte[])value, (int)0));
                }
            };
        }

        static Query newRangeQuery(String field, long lowerValueInclusive, long upperValueInclusive) {
            Preconditions.requireNonNull((Object)field, (String)"field cannot be null");
            Preconditions.checkArgument((lowerValueInclusive <= upperValueInclusive ? 1 : 0) != 0, (String)"upper bound for integral range cannot be lower than lower bound");
            return new PointRangeQuery(field, Lucene10ValueFields.longToBytes(lowerValueInclusive), Lucene10ValueFields.longToBytes(upperValueInclusive), 1){

                protected String toString(int dimension, byte[] value) {
                    return Long.toString(NumericUtils.sortableBytesToLong((byte[])value, (int)0));
                }
            };
        }

        static {
            FieldType type = new FieldType();
            type.setDimensions(1, 8);
            type.freeze();
            TYPE = type;
        }
    }

    static final class BooleanField
    extends Field {
        private static final FieldType TYPE;
        private static final BytesRef TRUE;
        private static final BytesRef FALSE;

        BooleanField(String name, boolean value) {
            super(name, (IndexableFieldType)TYPE);
            this.fieldsData = value ? TRUE : FALSE;
        }

        public boolean getBoolValue() {
            return this.fieldsData == TRUE;
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + " <" + this.name + ":" + this.getBoolValue() + ">";
        }

        public static TermQuery newExactQuery(String field, boolean value) {
            Term term = new Term(field, value ? TRUE : FALSE);
            return new TermQuery(term);
        }

        public static Query newRangeQuery(String field, boolean lowerValueInclusive, boolean upperValueInclusive) {
            Preconditions.checkArgument((!lowerValueInclusive || upperValueInclusive ? 1 : 0) != 0, (String)"upper bound for boolean range cannot be lower than lower bound");
            if (lowerValueInclusive) {
                return BooleanField.newExactQuery(field, true);
            }
            if (!upperValueInclusive) {
                return BooleanField.newExactQuery(field, false);
            }
            return new FieldExistsQuery(field);
        }

        static {
            TRUE = new BytesRef(new byte[1]);
            FALSE = new BytesRef(new byte[0]);
            FieldType type = new FieldType();
            type.setTokenized(false);
            type.setIndexOptions(IndexOptions.DOCS);
            type.freeze();
            TYPE = type;
        }
    }
}

