/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.lucene.LuceneContext;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectoryFactory;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9Directory;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.shaded.lucene9.store.ByteBuffersDirectory;
import org.neo4j.shaded.lucene9.store.Directory;
import org.neo4j.shaded.lucene9.store.FSDirectory;
import org.neo4j.shaded.lucene9.store.IOContext;
import org.neo4j.shaded.lucene9.store.IndexOutput;
import org.neo4j.shaded.lucene9.store.NIOFSDirectory;
import org.neo4j.shaded.lucene9.store.NRTCachingDirectory;

public class Lucene9DirectoryFactory
implements LuceneDirectoryFactory {
    public static final LuceneDirectoryFactory INSTANCE = new Lucene9DirectoryFactory();

    @Override
    public LuceneDirectory openPersistent(Path dir) throws IOException {
        Files.createDirectories(dir, new FileAttribute[0]);
        FSDirectory directory = USE_DEFAULT_DIRECTORY_FACTORY ? FSDirectory.open((Path)dir) : new NIOFSDirectory(dir);
        NRTCachingDirectory nrtCachingDirectory = new NRTCachingDirectory((Directory)directory, (double)MAX_MERGE_SIZE_MB, (double)MAX_CACHED_MB);
        return new Lucene9Directory((Directory)nrtCachingDirectory);
    }

    @Override
    public LuceneDirectory inMemoryDirectory() {
        return new Lucene9Directory((Directory)new ByteBuffersDirectory());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public DirectoryFactory newInMemoryDirectoryFactory() {
        return this.newInMemoryDirectoryFactory(null);
    }

    @Override
    public DirectoryFactory newInMemoryDirectoryFactory(FileSystemAbstraction fs) {
        return new Lucene9InMemoryDirectoryFactory(fs);
    }

    private static final class Lucene9InMemoryDirectoryFactory
    implements DirectoryFactory {
        private final Map<Path, Lucene9Directory> directories = new HashMap<Path, Lucene9Directory>();
        private final FileSystemAbstraction fs;

        public Lucene9InMemoryDirectoryFactory(FileSystemAbstraction fs) {
            this.fs = fs;
        }

        @Override
        public synchronized LuceneDirectory open(Path dir) {
            Lucene9Directory directory = this.directories.get(dir);
            if (directory == null) {
                directory = this.openFromFs(dir);
                this.directories.put(dir, directory);
            }
            return new LuceneDirectory.DelegatingLuceneDirectory(this, this.directories.get(dir)){

                @Override
                public void close() {
                }
            };
        }

        @Override
        public LuceneContext getContext() {
            return LuceneContext.LUCENE_9;
        }

        private Lucene9Directory openFromFs(Path dir) {
            ByteBuffersDirectory directory;
            block18: {
                directory = new ByteBuffersDirectory();
                if (this.fs != null) {
                    try {
                        if (!this.fs.fileExists(dir)) break block18;
                        if (!this.fs.isDirectory(dir)) {
                            throw new RuntimeException("File " + String.valueOf(dir) + " existed, but was not a directory");
                        }
                        for (Path file : this.fs.listFiles(dir)) {
                            try (InputStream in = this.fs.openAsInputStream(file);
                                 IndexOutput out = directory.createOutput(file.getFileName().toString(), IOContext.DEFAULT);){
                                int length = in.available();
                                byte[] bytes = new byte[length];
                                int bytesRead = in.read(bytes, 0, length);
                                if (bytesRead < length) {
                                    throw new RuntimeException("Couldn't read it all " + bytesRead + " < " + length);
                                }
                                out.writeBytes(bytes, 0, length);
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
            return new Lucene9Directory((Directory)directory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            try {
                if (this.fs != null) {
                    for (Map.Entry<Path, Lucene9Directory> entry : this.directories.entrySet()) {
                        Path directoryPath = entry.getKey();
                        this.fs.deleteRecursively(directoryPath);
                        this.fs.mkdirs(directoryPath);
                        Lucene9Directory directory = entry.getValue();
                        for (String name : directory.listAll()) {
                            Path filePath = directoryPath.resolve(name);
                            try (OutputStream out = this.fs.openAsOutputStream(filePath, false);){
                                byte[] bytes = directory.readFile(name);
                                out.write(bytes, 0, bytes.length);
                            }
                        }
                    }
                }
            }
            finally {
                IOUtils.closeAll(this.directories.values());
                this.directories.clear();
            }
        }
    }
}

