/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9Document;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9ReusableDocWithId;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9TrigramTokenStream;
import org.neo4j.kernel.api.impl.schema.vector.Neo4jVectorSimilarityFunction;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.document.Field;
import org.neo4j.shaded.lucene9.document.FieldType;
import org.neo4j.shaded.lucene9.index.IndexOptions;
import org.neo4j.shaded.lucene9.index.IndexableField;
import org.neo4j.shaded.lucene9.index.IndexableFieldType;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class Lucene9DocumentsFactory
implements LuceneDocumentsFactory {
    public static final LuceneDocumentsFactory INSTANCE = new Lucene9DocumentsFactory();

    @Override
    public LuceneDocument newDocument() {
        return new Lucene9Document();
    }

    @Override
    public LuceneDocument reusableTextDocument(long id, Value ... values) {
        return Lucene9ReusableDocWithId.reusableTextDocument(id, values);
    }

    @Override
    public LuceneDocument reusableFulltextDocument(long id, String[] propertyNames, Value[] values) {
        return Lucene9ReusableDocWithId.reusableFulltextDocument(id, propertyNames, values);
    }

    @Override
    public LuceneDocument createTrigramDocument(long id, Value value) {
        Lucene9Document document = new Lucene9Document();
        document.addStringField("id", Long.toString(id), false);
        document.addNumericField("id", id);
        if (value.valueGroup() == ValueGroup.TEXT) {
            Lucene9TrigramTokenStream tokenStream = new Lucene9TrigramTokenStream(value.asObject().toString());
            TrigramField valueField = new TrigramField("0", tokenStream);
            document.document.add((IndexableField)valueField);
        }
        return document;
    }

    @Override
    public LuceneDocument createVectorDocument(VectorDocumentStructure vectorDocumentStructure, long id, Neo4jVectorSimilarityFunction similarityFunction, Value[] values) {
        Preconditions.checkArgument((values != null && values.length == 1 ? 1 : 0) != 0, (String)"%s vector documents can only receive a single value", (Object[])new Object[]{this.getClass().getSimpleName()});
        float[] vector = LuceneDocumentsFactory.maybeVectorFromValues(values, similarityFunction);
        if (vector == null) {
            return null;
        }
        Lucene9Document document = new Lucene9Document();
        document.addStringField("id", Long.toString(id), false);
        document.addNumericField("id", id);
        document.addKnnFloatVectorField(vectorDocumentStructure.vectorValueKeyFor(vector.length), vector, similarityFunction);
        return document;
    }

    private static class TrigramField
    extends Field {
        private static final FieldType TYPE = new FieldType();

        private TrigramField(String name, TokenStream tokenStream) {
            super(name, tokenStream, (IndexableFieldType)TYPE);
        }

        static {
            TYPE.setOmitNorms(true);
            TYPE.setIndexOptions(IndexOptions.DOCS);
            TYPE.setTokenized(true);
            TYPE.setStored(false);
            TYPE.freeze();
        }
    }
}

