/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryContext;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryParseException;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9TrigramTokenStream;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9Utils;
import org.neo4j.kernel.api.impl.schema.TextDocumentStructure;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.shaded.lucene9.analysis.CharacterUtils;
import org.neo4j.shaded.lucene9.index.FilteredTermsEnum;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.index.Terms;
import org.neo4j.shaded.lucene9.index.TermsEnum;
import org.neo4j.shaded.lucene9.queryparser.classic.MultiFieldQueryParser;
import org.neo4j.shaded.lucene9.queryparser.classic.ParseException;
import org.neo4j.shaded.lucene9.queryparser.classic.QueryParserBase;
import org.neo4j.shaded.lucene9.search.BooleanClause;
import org.neo4j.shaded.lucene9.search.BooleanQuery;
import org.neo4j.shaded.lucene9.search.ConstantScoreQuery;
import org.neo4j.shaded.lucene9.search.KnnFloatVectorQuery;
import org.neo4j.shaded.lucene9.search.MatchAllDocsQuery;
import org.neo4j.shaded.lucene9.search.MultiTermQuery;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.QueryVisitor;
import org.neo4j.shaded.lucene9.search.TermQuery;
import org.neo4j.shaded.lucene9.search.WildcardQuery;
import org.neo4j.shaded.lucene9.util.AttributeSource;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.StringHelper;
import org.neo4j.values.storable.Value;

public class Lucene9QueryContext
implements LuceneQueryContext {
    private BooleanQuery.Builder booleanBuilder;
    private Query singleQuery;

    static Lucene9QueryContext wrap(Query query) {
        Lucene9QueryContext queryContext = new Lucene9QueryContext();
        queryContext.assignSingle(query);
        return queryContext;
    }

    @Override
    public Lucene9QueryContext addMustTerm(String field, String text) {
        this.ensureBooleanBuilder();
        this.booleanBuilder.add((Query)new TermQuery(new Term(field, text)), BooleanClause.Occur.MUST);
        return this;
    }

    @Override
    public Lucene9QueryContext addMustNotHaveField(String field) {
        this.ensureBooleanBuilder();
        this.booleanBuilder.add((Query)new ConstantScoreQuery((Query)new WildcardQuery(new Term(field, "*"))), BooleanClause.Occur.MUST_NOT);
        return this;
    }

    @Override
    public Lucene9QueryContext addShouldQueryText(String query, String[] fields, Analyzer analyzer) throws LuceneQueryParseException {
        try {
            this.ensureBooleanBuilder();
            this.booleanBuilder.add(this.parseFulltextQuery(query, fields, analyzer), BooleanClause.Occur.SHOULD);
            return this;
        }
        catch (ParseException e) {
            throw new LuceneQueryParseException((Exception)((Object)e));
        }
    }

    @Override
    public Lucene9QueryContext exactTerm(String entityIdKey, long entityId) {
        this.assignSingle((Query)new TermQuery(new Term(entityIdKey, Long.toString(entityId))));
        return this;
    }

    @Override
    public Lucene9QueryContext addExactTrigram(String value) {
        this.ensureBooleanBuilder();
        this.booleanBuilder.add(Lucene9QueryContext.trigramSearchQuery(value), BooleanClause.Occur.MUST);
        return this;
    }

    @Override
    public Lucene9QueryContext addConstantMustTerm(String field, String text) {
        this.ensureBooleanBuilder();
        ConstantScoreQuery termQuery = new ConstantScoreQuery((Query)new TermQuery(new Term(field, text)));
        this.booleanBuilder.add((Query)termQuery, BooleanClause.Occur.MUST);
        return this;
    }

    @Override
    public Lucene9QueryContext addMustSeek(Value ... propertyValues) {
        this.ensureBooleanBuilder();
        Lucene9QueryContext queryContext = new Lucene9QueryContext();
        TextDocumentStructure.seekStrings(propertyValues, queryContext);
        this.booleanBuilder.add(queryContext.build(), BooleanClause.Occur.MUST);
        return this;
    }

    @Override
    public Lucene9QueryContext matchAll() {
        this.assignSingle((Query)new MatchAllDocsQuery());
        return this;
    }

    @Override
    public Lucene9QueryContext stringPrefix(String prefix) {
        Term term = new Term(LuceneDocumentsFactory.textValueKey(0), prefix);
        this.assignSingle((Query)new PrefixMultiTermsQuery(term));
        return this;
    }

    @Override
    public Lucene9QueryContext stringContains(String substring) {
        Term term = new Term(LuceneDocumentsFactory.textValueKey(0), substring);
        this.assignSingle((Query)new ContainsMultiTermsQuery(term));
        return this;
    }

    @Override
    public Lucene9QueryContext stringSuffix(String suffix) {
        Term term = new Term(LuceneDocumentsFactory.textValueKey(0), suffix);
        this.assignSingle((Query)new SuffixMultiTermsQuery(term));
        return this;
    }

    @Override
    public Lucene9QueryContext trigramSearch(String searchString) {
        this.assignSingle(Lucene9QueryContext.trigramSearchQuery(searchString));
        return this;
    }

    @Override
    public Lucene9QueryContext approximateNearestNeighbors(VectorDocumentStructure documentStructure, float[] query, int k) {
        this.assignSingle((Query)new KnnFloatVectorQuery(documentStructure.vectorValueKeyFor(query.length), query, k));
        return this;
    }

    public Query build() {
        if (this.singleQuery != null) {
            return this.singleQuery;
        }
        return this.booleanBuilder.build();
    }

    private void ensureBooleanBuilder() {
        if (this.booleanBuilder == null) {
            if (this.singleQuery != null) {
                throw new IllegalStateException("Builder already assigned to an absolute query");
            }
            this.booleanBuilder = new BooleanQuery.Builder();
        }
    }

    private void assignSingle(Query single) {
        if (this.booleanBuilder != null) {
            throw new IllegalStateException("Cannot combine boolean with absolute queries");
        }
        if (this.singleQuery != null) {
            throw new IllegalStateException("Can only have one absolute query");
        }
        this.singleQuery = single;
    }

    private Query parseFulltextQuery(String query, String[] propertyNames, Analyzer analyzer) throws ParseException {
        MultiFieldQueryParser multiFieldQueryParser = new MultiFieldQueryParser(propertyNames, Lucene9Utils.loadAnalyzer(analyzer));
        multiFieldQueryParser.setAllowLeadingWildcard(true);
        return multiFieldQueryParser.parse(query);
    }

    private static Query trigramSearchQuery(String searchString) {
        if (searchString.isEmpty()) {
            return new MatchAllDocsQuery();
        }
        Lucene9TrigramTokenStream.CodePointBuffer codePointBuffer = Lucene9TrigramTokenStream.getCodePoints(searchString);
        if (codePointBuffer.codePointCount() < 3) {
            String searchTerm = QueryParserBase.escape((String)searchString);
            Term term = new Term("0", "*" + searchTerm + "*");
            return new WildcardQuery(term);
        }
        Lucene9QueryContext builder = new Lucene9QueryContext();
        for (int i = 0; i < codePointBuffer.codePointCount() - 2 && i < LuceneIndexSearcher.getMaxClauseCount(); ++i) {
            String term = Lucene9QueryContext.getNgram(codePointBuffer, i, 3);
            builder.addConstantMustTerm("0", term);
        }
        return builder.build();
    }

    private static String getNgram(Lucene9TrigramTokenStream.CodePointBuffer codePointBuffer, int ngramIndex, int n) {
        char[] termCharBuffer = new char[2 * n];
        int length = CharacterUtils.toChars((int[])codePointBuffer.codePoints(), (int)ngramIndex, (int)n, (char[])termCharBuffer, (int)0);
        return new String(termCharBuffer, 0, length);
    }

    private static class PrefixMultiTermsQuery
    extends MultiTermQuery {
        private final Term term;

        PrefixMultiTermsQuery(Term term) {
            super(term.field(), CONSTANT_SCORE_REWRITE);
            this.term = term;
        }

        protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
            return this.term.bytes().length == 0 ? terms.iterator() : new PrefixTermsEnum(terms.iterator(), this.term.bytes());
        }

        public String toString(String field) {
            return ((Object)((Object)this)).getClass().getSimpleName() + ", term:" + String.valueOf(this.term) + ", field:" + field;
        }

        public void visit(QueryVisitor visitor) {
            if (visitor.acceptField(this.term.field())) {
                visitor.consumeTerms((Query)this, new Term[]{this.term});
            }
        }

        private static class PrefixTermsEnum
        extends FilteredTermsEnum {
            private final BytesRef prefix;

            PrefixTermsEnum(TermsEnum termEnum, BytesRef prefix) {
                super(termEnum);
                this.prefix = prefix;
                this.setInitialSeekTerm(this.prefix);
            }

            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
                return StringHelper.startsWith((BytesRef)term, (BytesRef)this.prefix) ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.END;
            }
        }
    }

    private static class ContainsMultiTermsQuery
    extends MultiTermQuery {
        private final Term term;

        ContainsMultiTermsQuery(Term term) {
            super(term.field(), CONSTANT_SCORE_REWRITE);
            this.term = term;
        }

        protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
            return this.term.bytes().length == 0 ? terms.iterator() : new ContainsTermsEnum(terms.iterator(), this.term.bytes());
        }

        public String toString(String field) {
            return ((Object)((Object)this)).getClass().getSimpleName() + ", term:" + String.valueOf(this.term) + ", field:" + field;
        }

        public void visit(QueryVisitor visitor) {
            if (visitor.acceptField(this.term.field())) {
                visitor.consumeTerms((Query)this, new Term[]{this.term});
            }
        }

        private static class ContainsTermsEnum
        extends FilteredTermsEnum {
            private final BytesRef substring;

            ContainsTermsEnum(TermsEnum termsEnum, BytesRef substring) {
                super(termsEnum, false);
                this.substring = substring;
            }

            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
                if (this.substring.length > term.length) {
                    return FilteredTermsEnum.AcceptStatus.NO;
                }
                byte first = this.substring.bytes[this.substring.offset];
                int max = term.offset + term.length - this.substring.length;
                for (int pos = term.offset; pos <= max; ++pos) {
                    int i;
                    if (term.bytes[pos] != first) {
                        while (++pos <= max && term.bytes[pos] != first) {
                        }
                    }
                    if (pos > max) continue;
                    int end = pos + this.substring.length;
                    int j = this.substring.offset + 1;
                    for (i = pos + 1; i < end && term.bytes[i] == this.substring.bytes[j]; ++i) {
                        ++j;
                    }
                    if (i != end) continue;
                    return FilteredTermsEnum.AcceptStatus.YES;
                }
                return FilteredTermsEnum.AcceptStatus.NO;
            }
        }
    }

    private static class SuffixMultiTermsQuery
    extends MultiTermQuery {
        private final Term term;

        SuffixMultiTermsQuery(Term term) {
            super(term.field(), CONSTANT_SCORE_REWRITE);
            this.term = term;
        }

        protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
            return this.term.bytes().length == 0 ? terms.iterator() : new SuffixTermsEnum(terms.iterator(), this.term.bytes());
        }

        public String toString(String field) {
            return ((Object)((Object)this)).getClass().getSimpleName() + ", term:" + String.valueOf(this.term) + ", field:" + field;
        }

        public void visit(QueryVisitor visitor) {
            if (visitor.acceptField(this.term.field())) {
                visitor.consumeTerms((Query)this, new Term[]{this.term});
            }
        }

        private static class SuffixTermsEnum
        extends FilteredTermsEnum {
            private final BytesRef suffix;

            SuffixTermsEnum(TermsEnum termsEnum, BytesRef suffix) {
                super(termsEnum, false);
                this.suffix = suffix;
            }

            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
                return StringHelper.endsWith((BytesRef)term, (BytesRef)this.suffix) ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.NO;
            }
        }
    }
}

