/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9Document;
import org.neo4j.shaded.lucene9.document.Document;
import org.neo4j.shaded.lucene9.document.Field;
import org.neo4j.shaded.lucene9.document.NumericDocValuesField;
import org.neo4j.shaded.lucene9.document.StringField;
import org.neo4j.shaded.lucene9.document.TextField;
import org.neo4j.shaded.lucene9.index.IndexableField;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

abstract class Lucene9ReusableDocWithId {
    final LuceneDocument luceneDocument;
    final Document document;
    final Field idField;
    final Field idValueField;

    Lucene9ReusableDocWithId(String fieldEntityId) {
        this.idField = new StringField(fieldEntityId, "", Field.Store.YES);
        this.idValueField = new NumericDocValuesField(fieldEntityId, 0L);
        this.document = new Document();
        this.document.add((IndexableField)this.idField);
        this.document.add((IndexableField)this.idValueField);
        this.luceneDocument = new Lucene9Document(this.document);
    }

    static LuceneDocument reusableTextDocument(long nodeId, Value ... values) {
        Lucene9ReusableTextDocWithId doc = Lucene9ReusableTextDocWithId.PER_THREAD_DOCUMENT.get();
        doc.setId(nodeId);
        doc.setValues(values);
        return doc.luceneDocument;
    }

    static LuceneDocument reusableFulltextDocument(long id, String[] propertyNames, Value[] values) {
        Lucene9ReusableFulltextDocWithId doc = Lucene9ReusableFulltextDocWithId.PER_THREAD_DOCUMENT.get();
        doc.setId(id);
        int setValues = doc.setValues(propertyNames, values);
        return setValues == 0 ? null : doc.luceneDocument;
    }

    void setId(long id) {
        this.resetFields();
        this.idField.setStringValue(Long.toString(id));
        this.idValueField.setLongValue(id);
    }

    private void resetFields() {
        this.document.clear();
        this.document.add((IndexableField)this.idField);
        this.document.add((IndexableField)this.idValueField);
    }

    private static class Lucene9ReusableTextDocWithId
    extends Lucene9ReusableDocWithId {
        private static final ThreadLocal<Lucene9ReusableTextDocWithId> PER_THREAD_DOCUMENT = ThreadLocal.withInitial(Lucene9ReusableTextDocWithId::new);
        private Field[] reusableValueFields = new Field[0];

        Lucene9ReusableTextDocWithId() {
            super("id");
        }

        public void setValues(Value ... values) {
            int neededLength = values.length;
            if (this.reusableValueFields.length < neededLength) {
                this.reusableValueFields = new Field[neededLength];
            }
            for (int i = 0; i < values.length; ++i) {
                if (values[i].valueGroup() != ValueGroup.TEXT) continue;
                Field reusableField = this.getFieldWithValue(i, values[i]);
                this.document.add((IndexableField)reusableField);
            }
        }

        private Field getFieldWithValue(int propertyNumber, Value value) {
            String key = LuceneDocumentsFactory.textValueKey(propertyNumber);
            Field reusableField = this.reusableValueFields[propertyNumber];
            if (reusableField == null) {
                this.reusableValueFields[propertyNumber] = reusableField = new StringField(key, value.asObject().toString(), Field.Store.NO);
            } else {
                reusableField.setStringValue(value.asObject().toString());
            }
            return reusableField;
        }
    }

    private static class Lucene9ReusableFulltextDocWithId
    extends Lucene9ReusableDocWithId {
        private static final ThreadLocal<Lucene9ReusableFulltextDocWithId> PER_THREAD_DOCUMENT = ThreadLocal.withInitial(Lucene9ReusableFulltextDocWithId::new);

        private Lucene9ReusableFulltextDocWithId() {
            super("__neo4j__lucene__fulltext__index__internal__id__");
        }

        public int setValues(String[] names, Value[] values) {
            int i = 0;
            int nbrAddedValues = 0;
            for (String name : names) {
                Value value;
                if ((value = values[i++]) == null) continue;
                if (value.valueGroup() == ValueGroup.TEXT) {
                    this.document.add((IndexableField)Lucene9ReusableFulltextDocWithId.encodeValueField(name, value));
                    ++nbrAddedValues;
                }
                if (value.valueGroup() != ValueGroup.TEXT_ARRAY) continue;
                TextArray array = (TextArray)value;
                for (AnyValue val : array) {
                    this.document.add((IndexableField)Lucene9ReusableFulltextDocWithId.encodeValueField(name, (Value)val));
                }
                ++nbrAddedValues;
            }
            return nbrAddedValues;
        }

        private static Field encodeValueField(String propertyKey, Value value) {
            TextValue textValue = (TextValue)value;
            String stringValue = textValue.stringValue();
            return new TextField(propertyKey, stringValue, Field.Store.NO);
        }
    }
}

