/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.analysis.StopwordAnalyzerBase;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.Tokenizer;
import org.neo4j.shaded.lucene9.analysis.core.LowerCaseFilter;
import org.neo4j.shaded.lucene9.analysis.core.StopFilter;
import org.neo4j.shaded.lucene9.analysis.en.EnglishAnalyzer;
import org.neo4j.shaded.lucene9.analysis.miscellaneous.ASCIIFoldingFilter;
import org.neo4j.shaded.lucene9.analysis.standard.StandardTokenizer;

public class Lucene9StandardFoldingAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;

    public Lucene9StandardFoldingAnalyzer() {
        super(EnglishAnalyzer.ENGLISH_STOP_WORDS_SET);
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer src = new StandardTokenizer();
        src.setMaxTokenLength(255);
        ASCIIFoldingFilter tok = new ASCIIFoldingFilter((TokenStream)src);
        tok = new LowerCaseFilter((TokenStream)tok);
        tok = new StopFilter((TokenStream)tok, this.stopwords);
        return new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)tok);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

