/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import org.neo4j.shaded.lucene9.analysis.CharacterUtils;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.CharTermAttribute;

final class Lucene9TrigramTokenStream
extends TokenStream {
    private static final int N = 3;
    private static final int MAX_CHARS = 3 * Character.charCount(0x10FFFF);
    private final CodePointBuffer codePointBuffer;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private int offset = -1;

    public Lucene9TrigramTokenStream(String text) {
        this.codePointBuffer = Lucene9TrigramTokenStream.getCodePoints(text);
        this.termAtt.resizeBuffer(MAX_CHARS);
    }

    public boolean incrementToken() {
        this.clearAttributes();
        if (this.offset == -1 && this.codePointBuffer.codePointCount < 3) {
            int length = CharacterUtils.toChars((int[])this.codePointBuffer.codePoints, (int)0, (int)this.codePointBuffer.codePointCount, (char[])this.termAtt.buffer(), (int)0);
            this.termAtt.setLength(length);
            this.offset = this.codePointBuffer.codePointCount;
            return true;
        }
        ++this.offset;
        if (this.codePointBuffer.codePointCount - this.offset < 3) {
            return false;
        }
        int length = CharacterUtils.toChars((int[])this.codePointBuffer.codePoints, (int)this.offset, (int)3, (char[])this.termAtt.buffer(), (int)0);
        this.termAtt.setLength(length);
        return true;
    }

    static CodePointBuffer getCodePoints(String text) {
        int charCount;
        int[] codePointBuffer = new int[text.length()];
        int codePointCount = 0;
        for (int i = 0; i < text.length(); i += charCount) {
            int cp = text.codePointAt(i);
            charCount = Character.charCount(cp);
            codePointBuffer[codePointCount++] = cp;
        }
        return new CodePointBuffer(codePointBuffer, codePointCount);
    }

    public record CodePointBuffer(int[] codePoints, int codePointCount) {
    }
}

