/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9.codec;

import java.io.IOException;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfig;
import org.neo4j.shaded.lucene9.codecs.KnnVectorsFormat;
import org.neo4j.shaded.lucene9.codecs.KnnVectorsReader;
import org.neo4j.shaded.lucene9.codecs.KnnVectorsWriter;
import org.neo4j.shaded.lucene9.codecs.lucene99.Lucene99HnswVectorsFormat;
import org.neo4j.shaded.lucene9.index.SegmentReadState;
import org.neo4j.shaded.lucene9.index.SegmentWriteState;

public class LuceneKnnVectorFormatV2
extends KnnVectorsFormat {
    private static final String LUCENE_VECTOR_FORMAT_V2_NAME = "LuceneKnnVectorFormatV2";
    private final KnnVectorsFormat vectorsFormat;
    private final int maxDimensions;

    public LuceneKnnVectorFormatV2() {
        this(Integer.MAX_VALUE, VectorIndexConfig.HnswConfig.DUMMY);
    }

    public LuceneKnnVectorFormatV2(int maxDimensions, VectorIndexConfig.HnswConfig hnswConfig) {
        super(LUCENE_VECTOR_FORMAT_V2_NAME);
        this.maxDimensions = maxDimensions;
        this.vectorsFormat = new Lucene99HnswVectorsFormat(hnswConfig.M(), hnswConfig.efConstruction());
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return this.vectorsFormat.fieldsWriter(state);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return this.vectorsFormat.fieldsReader(state);
    }

    public int getMaxDimensions(String fieldName) {
        return this.maxDimensions;
    }
}

