/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.lucene.LuceneContext;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectoryFactory;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10DirectoryFactory;

public interface DirectoryFactory
extends AutoCloseable {
    public static final LuceneDirectoryFactory CURRENT = Lucene10DirectoryFactory.INSTANCE;

    public LuceneDirectory open(Path var1) throws IOException;

    public LuceneContext getContext();

    public static DirectoryFactory directoryFactory(LuceneContext luceneContext, FileSystemAbstraction fs) {
        return fs.isPersistent() ? DirectoryFactory.persistent(luceneContext) : DirectoryFactory.inMemory(luceneContext, fs);
    }

    public static DirectoryFactory persistent(LuceneContext luceneContext) {
        return new PersistentDirectoryFactory(luceneContext);
    }

    public static DirectoryFactory inMemory(LuceneContext luceneContext) {
        return luceneContext.directoryFactory().newInMemoryDirectoryFactory();
    }

    public static DirectoryFactory inMemory(LuceneContext luceneContext, FileSystemAbstraction fs) {
        return luceneContext.directoryFactory().newInMemoryDirectoryFactory(fs);
    }

    public static class PersistentDirectoryFactory
    implements DirectoryFactory {
        private final LuceneContext luceneContext;

        private PersistentDirectoryFactory(LuceneContext luceneContext) {
            this.luceneContext = luceneContext;
        }

        @Override
        public LuceneDirectory open(Path dir) throws IOException {
            return this.luceneContext.directoryFactory().openPersistent(dir);
        }

        @Override
        public LuceneContext getContext() {
            return this.luceneContext;
        }

        @Override
        public void close() throws Exception {
        }
    }
}

