/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.nio.file.OpenOption;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.impl.index.LuceneMinimalIndexAccessor;
import org.neo4j.kernel.api.impl.index.MinimalDatabaseIndex;
import org.neo4j.kernel.api.impl.index.SchemaIndexMigrator;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.IndexStorageFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.util.VisibleForTesting;

public abstract class AbstractLuceneIndexProvider
extends IndexProvider {
    private final IndexStorageFactory indexStorageFactory;
    private final IndexProvider.Monitor monitor;
    private final IndexType supportedIndexType;
    protected final Config config;
    protected final DatabaseReadOnlyChecker readOnlyChecker;
    protected final LogProvider logProvider;

    public AbstractLuceneIndexProvider(KernelVersion minimumRequiredVersion, IndexType supportedIndexType, IndexProviderDescriptor descriptor, FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, IndexDirectoryStructure.Factory directoryStructureFactory, Monitors monitors, Config config, DatabaseReadOnlyChecker readOnlyChecker, LogProvider logProvider) {
        super(minimumRequiredVersion, descriptor, directoryStructureFactory);
        this.supportedIndexType = supportedIndexType;
        this.readOnlyChecker = readOnlyChecker;
        this.monitor = (IndexProvider.Monitor)monitors.newMonitor(IndexProvider.Monitor.class, new String[]{descriptor.toString()});
        this.indexStorageFactory = this.buildIndexStorageFactory(fileSystem, directoryFactory);
        this.config = config;
        this.logProvider = logProvider;
    }

    @VisibleForTesting
    protected IndexStorageFactory buildIndexStorageFactory(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory) {
        return new IndexStorageFactory(directoryFactory, fileSystem, this.directoryStructure());
    }

    public IndexPrototype validatePrototype(IndexPrototype prototype) {
        IndexType indexType = prototype.getIndexType();
        String providerName = this.getProviderDescriptor().name();
        if (indexType != this.supportedIndexType) {
            throw InvalidArgumentException.invalidIndexInput((String)indexType.toString(), (String)providerName, (String)"The '%s' index provider does not support %s indexes: %s".formatted(providerName, indexType, prototype));
        }
        if (prototype.isUnique()) {
            throw InvalidArgumentException.invalidIndexInput((String)indexType.toString(), (String)providerName, (String)"The '%s' index provider does not support unique indexes: %s".formatted(providerName, prototype));
        }
        return prototype;
    }

    public IndexType getIndexType() {
        return this.supportedIndexType;
    }

    public MinimalIndexAccessor getMinimalIndexAccessor(IndexDescriptor descriptor, boolean forRebuildDuringRecovery) {
        PartitionedIndexStorage indexStorage = this.indexStorageFactory.indexStorageOf(descriptor.getId());
        MinimalDatabaseIndex index = new MinimalDatabaseIndex(indexStorage, descriptor, this.config, this.logProvider);
        return new LuceneMinimalIndexAccessor(descriptor, index, this.readOnlyChecker.isReadOnly());
    }

    public InternalIndexState getInitialState(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) {
        PartitionedIndexStorage indexStorage = this.getIndexStorage(descriptor.getId());
        String failure = indexStorage.getStoredIndexFailure();
        if (failure != null) {
            return InternalIndexState.FAILED;
        }
        try {
            return AbstractLuceneIndexProvider.indexIsOnline(indexStorage, descriptor, this.config, this.logProvider) ? InternalIndexState.ONLINE : InternalIndexState.POPULATING;
        }
        catch (IOException e) {
            this.monitor.failedToOpenIndex(descriptor, "Requesting re-population.", (Exception)e);
            return InternalIndexState.POPULATING;
        }
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, PageCacheTracer pageCacheTracer, StorageEngineFactory storageEngineFactory, CursorContextFactory contextFactory) {
        return new SchemaIndexMigrator(this.getProviderDescriptor().name(), fs, pageCache, pageCacheTracer, this.directoryStructure(), storageEngineFactory, contextFactory);
    }

    public String getPopulationFailure(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) throws IllegalStateException {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.getIndexStorage(descriptor.getId()).getStoredIndexFailure(), (CharSequence)"");
    }

    protected PartitionedIndexStorage getIndexStorage(long indexId) {
        return this.indexStorageFactory.indexStorageOf(indexId);
    }

    public void shutdown() throws Exception {
        this.indexStorageFactory.close();
    }

    public static boolean indexIsOnline(PartitionedIndexStorage indexStorage, IndexDescriptor descriptor, Config config, LogProvider logProvider) throws IOException {
        try (MinimalDatabaseIndex index = new MinimalDatabaseIndex(indexStorage, descriptor, config, logProvider);){
            if (index.exists()) {
                index.open();
                boolean bl = index.isOnline();
                return bl;
            }
            throw new IOException("Index does not exist");
        }
    }
}

