/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.fulltext;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.neo4j.configuration.Config;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.fulltext.FulltextIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.logging.LogProvider;
import org.neo4j.token.api.TokenHolder;

public class FulltextIndex
extends AbstractLuceneIndex<FulltextIndexReader>
implements Closeable {
    private final Config config;
    private final Analyzer analyzer;
    private final TokenHolder propertyKeyTokenHolder;
    private final String[] propertyNames;
    private final Path transactionsFolder;

    FulltextIndex(PartitionedIndexStorage storage, IndexPartitionFactory partitionFactory, IndexDescriptor descriptor, TokenHolder propertyKeyTokenHolder, Config config, Analyzer analyzer, String[] propertyNames, LogProvider logProvider) {
        super(storage, partitionFactory, descriptor, config, logProvider);
        this.config = config;
        this.analyzer = analyzer;
        this.propertyNames = propertyNames;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        Path indexFolder = storage.getIndexFolder();
        this.transactionsFolder = indexFolder.resolve(String.valueOf(indexFolder.getFileName()) + ".tx");
    }

    @Override
    public void open() throws IOException {
        super.open();
        this.indexStorage.prepareFolder(this.transactionsFolder);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.indexStorage.cleanupFolder(this.transactionsFolder);
    }

    @Override
    protected FulltextIndexReader createSimpleReader(List<AbstractIndexPartition> partitions, IndexUsageTracking usageTracker) throws IOException {
        return this.createPartitionedReader(partitions, usageTracker);
    }

    @Override
    protected FulltextIndexReader createPartitionedReader(List<AbstractIndexPartition> partitions, IndexUsageTracking usageTracker) throws IOException {
        List<SearcherReference> searchers = FulltextIndex.acquireSearchers(partitions);
        return new FulltextIndexReader(searchers, this.luceneContext(), this.propertyKeyTokenHolder, this.getDescriptor(), this.config, this.analyzer, this.propertyNames, usageTracker, this.logProvider);
    }
}

