/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.fulltext;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Map;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.schema.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

public class FulltextIndexPopulator
extends LuceneIndexPopulator<DatabaseIndex<FulltextIndexReader>> {
    private final IndexDescriptor descriptor;
    private final String[] propertyNames;

    FulltextIndexPopulator(IndexDescriptor descriptor, DatabaseIndex<FulltextIndexReader> luceneFulltext, String[] propertyNames, IndexUpdateIgnoreStrategy ignoreStrategy) {
        super(luceneFulltext, ignoreStrategy);
        this.descriptor = descriptor;
        this.propertyNames = propertyNames;
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate> updates, CursorContext cursorContext) {
        try {
            for (IndexEntryUpdate indexEntryUpdate : updates) {
                ValueIndexEntryUpdate valueUpdate = (ValueIndexEntryUpdate)indexEntryUpdate;
                if (this.ignoreStrategy.ignore(valueUpdate.values())) continue;
                this.writer.updateOrDeleteDocument("__neo4j__lucene__fulltext__index__internal__id__", valueUpdate.getEntityId(), this.updateAsDocument(valueUpdate));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
        return new PopulatingFulltextIndexUpdater();
    }

    @Override
    public IndexSample sample(CursorContext cursorContext) {
        return new IndexSample();
    }

    public Map<String, Value> indexConfig() {
        return this.descriptor.getIndexConfig().asMap();
    }

    @Override
    protected LuceneDocument updateAsDocument(ValueIndexEntryUpdate update) {
        Value[] values = update.values();
        return this.documentsFactory.reusableFulltextDocument(update.getEntityId(), this.propertyNames, values);
    }

    private class PopulatingFulltextIndexUpdater
    implements IndexUpdater {
        private PopulatingFulltextIndexUpdater() {
        }

        public void process(IndexEntryUpdate update) {
            ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
            if (FulltextIndexPopulator.this.ignoreStrategy.ignore(valueUpdate)) {
                return;
            }
            try {
                long nodeId = valueUpdate.getEntityId();
                switch (valueUpdate.updateMode()) {
                    case ADDED: 
                    case CHANGED: {
                        Value[] values = valueUpdate.values();
                        FulltextIndexPopulator.this.luceneIndex.getIndexWriter().updateOrDeleteDocument("__neo4j__lucene__fulltext__index__internal__id__", nodeId, FulltextIndexPopulator.this.documentsFactory.reusableFulltextDocument(nodeId, FulltextIndexPopulator.this.propertyNames, values));
                        break;
                    }
                    case REMOVED: {
                        FulltextIndexPopulator.this.luceneIndex.getIndexWriter().deleteDocuments("__neo4j__lucene__fulltext__index__internal__id__", nodeId);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void close() {
        }
    }
}

