/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.fulltext;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongPredicate;
import org.apache.lucene.analysis.Analyzer;
import org.eclipse.collections.impl.block.factory.primitive.LongPredicates;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.kernel.api.impl.index.lucene.LuceneContext;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.LucenePartitionedSearch;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryContext;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryParseException;
import org.neo4j.kernel.api.impl.schema.LuceneScoredEntityIndexProgressor;
import org.neo4j.kernel.api.impl.schema.fulltext.FulltextIndexAnalyzerLoader;
import org.neo4j.kernel.api.impl.schema.fulltext.FulltextIndexSettings;
import org.neo4j.kernel.api.impl.schema.fulltext.FulltextIndexTransactionState;
import org.neo4j.kernel.api.impl.schema.fulltext.LuceneFulltextDocumentStructure;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.Value;

public class FulltextIndexReader
implements ValueIndexReader {
    private static final LongPredicate ALWAYS_FALSE = LongPredicates.alwaysFalse();
    private final List<SearcherReference> searchers;
    private final TokenHolder propertyKeyTokenHolder;
    private final IndexDescriptor index;
    private final Analyzer analyzer;
    private final String[] propertyNames;
    private final FulltextIndexTransactionState transactionState;
    private final IndexUsageTracking usageTracker;
    private final Log log;

    FulltextIndexReader(List<SearcherReference> searchers, LuceneContext luceneContext, TokenHolder propertyKeyTokenHolder, IndexDescriptor descriptor, Config config, Analyzer analyzer, String[] propertyNames, IndexUsageTracking usageTracker, LogProvider logProvider) {
        this.searchers = searchers;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.index = descriptor;
        this.analyzer = analyzer;
        this.propertyNames = propertyNames;
        this.usageTracker = usageTracker;
        this.transactionState = new FulltextIndexTransactionState(luceneContext, descriptor, config, analyzer, propertyNames);
        this.log = logProvider.getLog(this.getClass());
    }

    public IndexSampler createSampler() {
        return IndexSampler.EMPTY;
    }

    public void query(IndexProgressor.EntityValueClient client, QueryContext queryContext, CursorContext cursorContext, IndexQueryConstraints constraints, PropertyIndexQuery ... queries) throws IndexNotApplicableKernelException {
        this.validateQuery(constraints, queries);
        PropertyIndexQuery predicate = queries[0];
        ValuesIterator iterator = this.searchers.isEmpty() ? ValuesIterator.EMPTY : this.searchLucene(this.toLuceneQuery(predicate), constraints, queryContext, queryContext.cursorContext(), queryContext.memoryTracker());
        queryContext.monitor().queried(this.index);
        this.usageTracker.queried();
        LuceneScoredEntityIndexProgressor progressor = new LuceneScoredEntityIndexProgressor(iterator, client, constraints);
        client.initializeQuery(this.index, (IndexProgressor)progressor, true, false, constraints, queries);
    }

    public void validateQuery(IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates.length > 1) {
            throw this.invalidCompositeQuery(msg -> IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)this.index.getName(), (String)msg), predicates);
        }
        PropertyIndexQuery predicate = predicates[0];
        if (!this.index.getCapability().isQuerySupported(predicate.type(), predicate.valueCategory())) {
            throw this.invalidQuery(msg -> IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)this.index.getName(), (String)msg), predicate);
        }
    }

    private <E extends Exception> E invalidCompositeQuery(Function<String, E> constructor, PropertyIndexQuery ... predicates) {
        IndexType indexType = this.index.getIndexType();
        return (E)((Exception)constructor.apply("Tried to query a %s index with a composite query. Composite queries are not supported by a %s index. Query was: %s ".formatted(indexType, indexType, Arrays.toString(predicates))));
    }

    private LuceneQueryContext toLuceneQuery(PropertyIndexQuery predicate) {
        LuceneQueryContext luceneQueryContext;
        LuceneIndexSearcher indexSearcher = this.searchers.getFirst().getIndexSearcher();
        switch (predicate.type()) {
            case ALL_ENTRIES: {
                LuceneQueryContext luceneQueryContext2;
                luceneQueryContext = luceneQueryContext2 = indexSearcher.newQueryContext().matchAll();
                break;
            }
            case FULLTEXT_SEARCH: {
                PropertyIndexQuery.FulltextSearchPredicate fulltextSearchPredicate = (PropertyIndexQuery.FulltextSearchPredicate)predicate;
                try {
                    LuceneQueryContext luceneQueryContext3;
                    LuceneQueryContext queryContext = indexSearcher.newQueryContext();
                    String queryAnalyzer = fulltextSearchPredicate.queryAnalyzer();
                    Analyzer actualQueryAnalyzer = queryAnalyzer != null ? FulltextIndexAnalyzerLoader.INSTANCE.createAnalyzerFromString(queryAnalyzer) : this.analyzer;
                    queryContext.addShouldQueryText(fulltextSearchPredicate.query(), this.propertyNames, actualQueryAnalyzer);
                    luceneQueryContext = luceneQueryContext3 = queryContext;
                    break;
                }
                catch (LuceneQueryParseException parseException) {
                    throw new RuntimeException("Could not parse the given fulltext search query: '%s'.".formatted(fulltextSearchPredicate.query()), parseException);
                }
            }
            default: {
                throw this.invalidQuery(IllegalArgumentException::new, predicate);
            }
        }
        return luceneQueryContext;
    }

    private <E extends Exception> E invalidQuery(Function<String, E> constructor, PropertyIndexQuery query) {
        return (E)((Exception)constructor.apply("A fulltext schema index cannot answer %s queries on %s values.".formatted(query.type(), query.valueCategory())));
    }

    public PartitionedValueSeek valueSeek(int desiredNumberOfPartitions, QueryContext context, PropertyIndexQuery ... query) {
        throw new UnsupportedOperationException();
    }

    public IndexUsageTracking usageTracking() {
        return this.usageTracker;
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        long count = 0L;
        for (SearcherReference searcher : this.searchers) {
            try {
                String[] propertyKeys = new String[propertyKeyIds.length];
                for (int i = 0; i < propertyKeyIds.length; ++i) {
                    propertyKeys[i] = this.getPropertyKeyName(propertyKeyIds[i]);
                }
                LuceneIndexSearcher indexSearcher = searcher.getIndexSearcher();
                LuceneQueryContext queryContext = LuceneFulltextDocumentStructure.newCountEntityEntriesQuery(indexSearcher, entityId, propertyKeys, propertyValues);
                count += (long)indexSearcher.count(queryContext);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return count;
    }

    public void close() {
        ArrayList<Closeable> resources = new ArrayList<Closeable>(this.searchers.size() + 1);
        resources.addAll(this.searchers);
        resources.add(this.transactionState);
        IOUtils.close(IndexReaderCloseException::new, resources);
    }

    private ValuesIterator searchLucene(LuceneQueryContext queryContext, IndexQueryConstraints constraints, QueryContext context, CursorContext cursorContext, MemoryTracker memoryTracker) {
        try {
            LuceneIndexSearcher firstSearcher = this.searchers.getFirst().getIndexSearcher();
            queryContext = firstSearcher.rewrite(queryContext);
            boolean includeTransactionState = context.getTransactionStateOrNull() != null && !FulltextIndexSettings.isEventuallyConsistent(this.index);
            LongPredicate filter = includeTransactionState ? this.transactionState.isModifiedInTransactionPredicate() : ALWAYS_FALSE;
            LucenePartitionedSearch partitionedSearch = firstSearcher.newPartitionedSearcher(this.searchers.size() + 1);
            for (SearcherReference searcher : this.searchers) {
                partitionedSearch.addPartitionSearcher(searcher.getIndexSearcher(), filter);
            }
            if (includeTransactionState) {
                SearcherReference reference = this.transactionState.maybeUpdate(context, cursorContext, memoryTracker);
                partitionedSearch.addPartitionSearcher(reference.getIndexSearcher(), ALWAYS_FALSE);
            }
            return partitionedSearch.search(queryContext, constraints);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPropertyKeyName(int propertyKey) throws TokenNotFoundException {
        return this.propertyKeyTokenHolder.getTokenById(propertyKey).name();
    }
}

