/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.fulltext;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.neo4j.configuration.Config;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigBuilder;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigMode;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.lucene.LuceneContext;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectoryReader;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexWriter;
import org.neo4j.kernel.api.impl.schema.fulltext.DirectSearcherReference;
import org.neo4j.kernel.api.impl.schema.writer.LucenePartitionIndexWriter;

class TransactionStateLuceneIndexWriter
implements LucenePartitionIndexWriter,
Closeable {
    private final Config config;
    private final Analyzer analyzer;
    private LuceneIndexWriter writer;
    private final LuceneDirectory directory;

    TransactionStateLuceneIndexWriter(LuceneContext luceneContext, Config config, Analyzer analyzer) {
        this.config = config;
        this.analyzer = analyzer;
        this.directory = luceneContext.directoryFactory().inMemoryDirectory();
    }

    @Override
    public LuceneDocumentsFactory documentsFactory() {
        return this.directory.getLuceneContext().documentsFactory();
    }

    @Override
    public void addDocument(LuceneDocument document) throws IOException {
        this.writer.addDocument(document);
    }

    @Override
    public void addDocuments(int numDocs, Iterable<LuceneDocument> document) throws IOException {
        this.writer.addDocuments(document);
    }

    @Override
    public void updateDocument(String idField, long id, LuceneDocument document) throws IOException {
        this.writer.updateDocument(idField, id, document);
    }

    @Override
    public void deleteDocuments(String idField, long id) throws IOException {
        this.writer.deleteDocuments(idField, id);
    }

    @Override
    public void addDirectory(int count, LuceneDirectory directory) throws IOException {
        this.writer.addIndexes(directory);
    }

    void resetWriterState() throws IOException {
        if (this.writer != null) {
            this.writer.rollback();
        }
        this.openWriter();
    }

    private void openWriter() throws IOException {
        this.writer = this.directory.newWriter(new IndexWriterConfigBuilder(IndexWriterConfigMode.TRANSACTION_STATE, this.config).withAnalyzer(this.analyzer).build());
    }

    SearcherReference getNearRealTimeSearcher() throws IOException {
        LuceneDirectoryReader directoryReader = this.writer.directoryReader();
        return new DirectSearcherReference(directoryReader.newDirectSearcher(), directoryReader);
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.writer, this.directory});
    }
}

