/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.text;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndexAccessor;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.LuceneIndexValueValidator;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.Value;

public class TextIndexAccessor
extends AbstractLuceneIndexAccessor<ValueIndexReader, DatabaseIndex<ValueIndexReader>> {
    private final LuceneIndexValueValidator valueValidator;

    public TextIndexAccessor(DatabaseIndex<ValueIndexReader> luceneIndex, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup, ElementIdMapper elementIdMapper, IndexUpdateIgnoreStrategy ignoreStrategy) {
        super(luceneIndex, descriptor, ignoreStrategy);
        this.valueValidator = new LuceneIndexValueValidator(descriptor, tokenNameLookup, elementIdMapper);
    }

    @Override
    protected IndexUpdater getIndexUpdater(IndexUpdateMode mode) {
        return new TextIndexUpdater(mode.requiresIdempotency(), mode.requiresRefresh());
    }

    public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
        return super.newAllEntriesReader(LuceneDocumentsFactory::getEntityId, fromIdInclusive, toIdExclusive);
    }

    public void validateBeforeCommit(long entityId, Value[] tuple) {
        this.valueValidator.validate(entityId, tuple);
    }

    private class TextIndexUpdater
    extends AbstractLuceneIndexAccessor.AbstractLuceneIndexUpdater {
        TextIndexUpdater(boolean idempotent, boolean refresh) {
            super((AbstractLuceneIndexAccessor)TextIndexAccessor.this, idempotent, refresh);
        }

        @Override
        protected void addIdempotent(long entityId, Value[] values) {
            try {
                LuceneDocument document = TextIndexAccessor.this.documentsFactory.reusableTextDocument(entityId, values);
                TextIndexAccessor.this.writer.updateOrDeleteDocument("id", entityId, document);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected void add(long entityId, Value[] values) {
            try {
                LuceneDocument document = TextIndexAccessor.this.documentsFactory.reusableTextDocument(entityId, values);
                TextIndexAccessor.this.writer.nullableAddDocument(document);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected void change(long entityId, Value[] values) {
            try {
                LuceneDocument document = TextIndexAccessor.this.documentsFactory.reusableTextDocument(entityId, values);
                TextIndexAccessor.this.writer.updateOrDeleteDocument("id", entityId, document);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected void remove(long entityId) {
            try {
                TextIndexAccessor.this.writer.deleteDocuments("id", entityId);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

