/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.text;

import java.io.IOException;
import java.nio.file.OpenOption;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigBuilder;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigMode;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.AbstractTextIndexProvider;
import org.neo4j.kernel.api.impl.schema.TextIndexCapability;
import org.neo4j.kernel.api.impl.schema.populator.TextIndexPopulator;
import org.neo4j.kernel.api.impl.schema.text.TextIndexAccessor;
import org.neo4j.kernel.api.impl.schema.text.TextIndexBuilder;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.ElementIdMapper;

public class TextIndexProvider
extends AbstractTextIndexProvider {
    public static final IndexCapability CAPABILITY = TextIndexCapability.text();
    private final FileSystemAbstraction fileSystem;

    public TextIndexProvider(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, IndexDirectoryStructure.Factory directoryStructureFactory, Monitors monitors, Config config, DatabaseReadOnlyChecker readOnlyChecker, LogProvider logProvider) {
        super(KernelVersion.VERSION_RANGE_POINT_TEXT_INDEXES_ARE_INTRODUCED, IndexType.TEXT, AllIndexProviderDescriptors.TEXT_V1_DESCRIPTOR, fileSystem, directoryFactory, directoryStructureFactory, monitors, config, readOnlyChecker, logProvider);
        this.fileSystem = fileSystem;
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index, StorageEngineIndexingBehaviour indexingBehaviour) {
        return index.getCapability().equals((Object)IndexCapability.NO_CAPABILITY) ? index.withIndexCapability(CAPABILITY) : index;
    }

    public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup, ElementIdMapper elementIdMapper, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour, IndexPopulator.Configuration configuration) {
        IndexWriterConfigBuilder writerConfigBuilder = new IndexWriterConfigBuilder(IndexWriterConfigMode.TEXT_POPULATION, this.config);
        DatabaseIndex<ValueIndexReader> index = ((TextIndexBuilder)((TextIndexBuilder)TextIndexBuilder.create(descriptor, this.readOnlyChecker, this.config, this.logProvider).withFileSystem(this.fileSystem)).withSamplingConfig(samplingConfig).withIndexStorage(this.getIndexStorage(descriptor.getId()))).withWriterConfig(writerConfigBuilder::build).build();
        if (index.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        return new TextIndexPopulator(index, UPDATE_IGNORE_STRATEGY);
    }

    public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup, ElementIdMapper elementIdMapper, ImmutableSet<OpenOption> openOptions, boolean readOnly, StorageEngineIndexingBehaviour indexingBehaviour) throws IOException {
        TextIndexBuilder builder = this.builder(descriptor, samplingConfig);
        if (readOnly) {
            builder = (TextIndexBuilder)builder.permanentlyReadOnly();
        }
        DatabaseIndex<ValueIndexReader> index = builder.build();
        index.open();
        return new TextIndexAccessor(index, descriptor, tokenNameLookup, elementIdMapper, UPDATE_IGNORE_STRATEGY);
    }

    private TextIndexBuilder builder(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        return (TextIndexBuilder)TextIndexBuilder.create(descriptor, this.readOnlyChecker, this.config, this.logProvider).withSamplingConfig(samplingConfig).withIndexStorage(this.getIndexStorage(descriptor.getId()));
    }
}

