/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.trigram;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndexAccessor;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.IndexValueValidator;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.values.storable.Value;

public class TrigramIndexAccessor
extends AbstractLuceneIndexAccessor<ValueIndexReader, DatabaseIndex<ValueIndexReader>> {
    private final IndexValueValidator validator;

    public TrigramIndexAccessor(DatabaseIndex<ValueIndexReader> luceneIndex, IndexDescriptor descriptor, IndexUpdateIgnoreStrategy ignoreStrategy, IndexValueValidator validator) {
        super(luceneIndex, descriptor, ignoreStrategy);
        this.validator = validator;
    }

    @Override
    protected IndexUpdater getIndexUpdater(IndexUpdateMode mode) {
        return new Updater(mode.requiresIdempotency(), mode.requiresRefresh());
    }

    public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
        try {
            return ((TrigramIndexReader)this.luceneIndex.getIndexReader(IndexUsageTracking.NO_USAGE_TRACKING)).newAllEntriesValueReader(fromIdInclusive, toIdExclusive);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void validateBeforeCommit(long entityId, Value[] tuple) {
        this.validator.validate(entityId, tuple);
    }

    private class Updater
    extends AbstractLuceneIndexAccessor.AbstractLuceneIndexUpdater {
        Updater(boolean idempotent, boolean refresh) {
            super((AbstractLuceneIndexAccessor)TrigramIndexAccessor.this, idempotent, refresh);
        }

        @Override
        protected void addIdempotent(long entityId, Value[] values) {
            try {
                LuceneDocument document = TrigramIndexAccessor.this.documentsFactory.createTrigramDocument(entityId, values[0]);
                TrigramIndexAccessor.this.writer.updateOrDeleteDocument("id", entityId, document);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected void add(long entityId, Value[] values) {
            try {
                LuceneDocument document = TrigramIndexAccessor.this.documentsFactory.createTrigramDocument(entityId, values[0]);
                TrigramIndexAccessor.this.writer.nullableAddDocument(document);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected void change(long entityId, Value[] values) {
            this.addIdempotent(entityId, values);
        }

        @Override
        protected void remove(long entityId) {
            try {
                TrigramIndexAccessor.this.writer.deleteDocuments("id", entityId);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

