/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.util.Set;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.map.sorted.ImmutableSortedMap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexConfigValidationRecords;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.values.storable.Value;

public abstract class IndexConfigValidationWrapper {
    private final IndexProviderDescriptor descriptor;
    private final ImmutableSortedSet<String> validSettingNames;
    private final ImmutableSortedSet<String> possibleValidSettingNames;
    private final IndexConfig config;
    private final ImmutableSortedMap<IndexSetting, Object> settings;

    protected IndexConfigValidationWrapper(IndexProviderDescriptor descriptor, IndexConfig config, ImmutableSortedMap<IndexSetting, Object> settings, ImmutableSortedSet<String> validSettingNames, ImmutableSortedSet<String> possibleValidSettingNames) {
        this.descriptor = descriptor;
        this.validSettingNames = validSettingNames;
        this.possibleValidSettingNames = possibleValidSettingNames;
        this.config = this.validateSettingNames(config);
        this.settings = this.validatePossibleSettingNames(settings);
    }

    public IndexProviderDescriptor descriptor() {
        return this.descriptor;
    }

    public IndexConfig config() {
        return this.config;
    }

    public <T extends Value> T getValue(String setting) {
        if (!this.validSettingNames.contains((Object)setting)) {
            throw IndexConfigValidationWrapper.unrecognizedSetting(setting, this.validSettingNames);
        }
        return (T)this.config.get(setting);
    }

    public <T> T get(IndexSetting setting) {
        String settingName = setting.getSettingName();
        if (!this.possibleValidSettingNames.contains((Object)settingName)) {
            throw IndexConfigValidationWrapper.unrecognizedSetting(settingName, this.possibleValidSettingNames);
        }
        return (T)this.settings.get((Object)setting);
    }

    public static IndexConfigValidationRecords validateSettingNames(SetIterable<String> settingNames, SetIterable<String> validSettingNames) {
        IndexConfigValidationRecords validationRecords = new IndexConfigValidationRecords();
        ((MutableSet)settingNames.differenceInto(validSettingNames, (Set)Sets.mutable.empty())).asLazy().collect(IndexConfigValidationRecords.UnrecognizedSetting::new).forEach(arg_0 -> ((IndexConfigValidationRecords)validationRecords).with(arg_0));
        return validationRecords;
    }

    private IndexConfig validateSettingNames(IndexConfig config) {
        MutableSet settingNames = config.entries().asLazy().collect(Pair::getOne).toSet();
        this.assertValidSettingNames(IndexConfigValidationWrapper.validateSettingNames((SetIterable<String>)settingNames, this.validSettingNames), (Iterable<String>)this.validSettingNames);
        return config;
    }

    private ImmutableSortedMap<IndexSetting, Object> validatePossibleSettingNames(ImmutableSortedMap<IndexSetting, Object> settings) {
        MutableSet settingNames = settings.keysView().asLazy().collect(IndexSetting::getSettingName).toSet();
        this.assertValidSettingNames(IndexConfigValidationWrapper.validateSettingNames((SetIterable<String>)settingNames, this.possibleValidSettingNames), (Iterable<String>)this.possibleValidSettingNames);
        return settings;
    }

    private void assertValidSettingNames(IndexConfigValidationRecords validationRecords, Iterable<String> validSettingNames) {
        if (validationRecords.valid()) {
            return;
        }
        IndexConfigValidationRecords.IndexConfigValidationRecord invalidRecord = (IndexConfigValidationRecords.IndexConfigValidationRecord)IndexConfigValidationRecords.State.INVALID_STATES.asLazy().flatCollect(arg_0 -> ((IndexConfigValidationRecords)validationRecords).get(arg_0)).getFirst();
        throw IndexConfigValidationWrapper.unrecognizedSetting(invalidRecord.settingName(), validSettingNames);
    }

    public static InvalidArgumentException unrecognizedSetting(String settingName, Iterable<String> validSettingNames) {
        return InvalidArgumentException.invalidIndexConfig((String)settingName, validSettingNames);
    }
}

