/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;

class VectorDocumentStructures {
    private static final VectorDocumentStructure V1 = new VectorDocumentStructure(){
        static final String VECTOR_VALUE_KEY = "vector";

        @Override
        public String vectorValueKeyFor(int dimensions) {
            return VECTOR_VALUE_KEY;
        }

        @Override
        public String booleanValueKeyFor(int propertyIndex) {
            throw new UnsupportedOperationException("V1 does not support single stage filtering");
        }

        @Override
        public String integralValueKeyFor(int propertyIndex) {
            throw new UnsupportedOperationException("V1 does not support single stage filtering");
        }

        @Override
        public String floatingValueKeyFor(int propertyIndex) {
            throw new UnsupportedOperationException("V1 does not support single stage filtering");
        }

        @Override
        public String textValueKeyFor(int propertyIndex) {
            throw new UnsupportedOperationException("V1 does not support single stage filtering");
        }

        @Override
        public String temporalValueKeyFor(int propertyIndex) {
            throw new UnsupportedOperationException("V1 does not support single stage filtering");
        }
    };
    private static final VectorDocumentStructure V2 = new VectorDocumentStructure(){
        static final String VECTOR_VALUE_KEY_SUFFIX = "d-vector";

        @Override
        public String vectorValueKeyFor(int dimensions) {
            return dimensions + VECTOR_VALUE_KEY_SUFFIX;
        }

        @Override
        public String booleanValueKeyFor(int propertyIndex) {
            throw new UnsupportedOperationException("V2 does not support single stage filtering");
        }

        @Override
        public String integralValueKeyFor(int propertyIndex) {
            throw new UnsupportedOperationException("V2 does not support single stage filtering");
        }

        @Override
        public String floatingValueKeyFor(int propertyIndex) {
            throw new UnsupportedOperationException("V2 does not support single stage filtering");
        }

        @Override
        public String textValueKeyFor(int propertyIndex) {
            throw new UnsupportedOperationException("V2 does not support single stage filtering");
        }

        @Override
        public String temporalValueKeyFor(int propertyIndex) {
            throw new UnsupportedOperationException("V2 does not support single stage filtering");
        }
    };
    private static final VectorDocumentStructure V3 = new VectorDocumentStructure(){
        static final String VECTOR_VALUE_KEY_SUFFIX = "d-vector";

        @Override
        public String vectorValueKeyFor(int dimensions) {
            return dimensions + VECTOR_VALUE_KEY_SUFFIX;
        }

        @Override
        public String booleanValueKeyFor(int propertyIndex) {
            return "boolean-" + propertyIndex;
        }

        @Override
        public String integralValueKeyFor(int propertyIndex) {
            return "integral-" + propertyIndex;
        }

        @Override
        public String floatingValueKeyFor(int propertyIndex) {
            return "floating-" + propertyIndex;
        }

        @Override
        public String textValueKeyFor(int propertyIndex) {
            return "text-" + propertyIndex;
        }

        @Override
        public String temporalValueKeyFor(int propertyIndex) {
            return "temporal-" + propertyIndex;
        }
    };

    VectorDocumentStructures() {
    }

    static VectorDocumentStructure documentStructureFor(VectorIndexVersion version) {
        return switch (version) {
            default -> throw new MatchException(null, null);
            case VectorIndexVersion.UNKNOWN -> null;
            case VectorIndexVersion.V1_0 -> V1;
            case VectorIndexVersion.V2_0 -> V2;
            case VectorIndexVersion.V3_0 -> V3;
        };
    }
}

