/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.map.sorted.ImmutableSortedMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;
import org.eclipse.collections.impl.tuple.Tuples;
import org.neo4j.exceptions.InternalException;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexConfigValidationRecords;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.impl.schema.vector.IndexConfigValidationWrapper;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class VectorIndexConfigUtils {
    static final Comparator<IndexSetting> INDEX_SETTING_COMPARATOR = Comparator.comparing(IndexSetting::getSettingName, String.CASE_INSENSITIVE_ORDER);
    static final IndexSetting DIMENSIONS = IndexSetting.vector_Dimensions();
    static final IndexSetting SIMILARITY_FUNCTION = IndexSetting.vector_Similarity_Function();
    static final IndexSetting QUANTIZATION_ENABLED = IndexSetting.vector_Quantization_Enabled();
    static final IndexSetting HNSW_M = IndexSetting.vector_Hnsw_M();
    static final IndexSetting HNSW_EF_CONSTRUCTION = IndexSetting.vector_Hnsw_Ef_Construction();
    public static final ImmutableSortedMap<IndexSetting, KernelVersion> INDEX_SETTING_INTRODUCED_VERSIONS = TreeSortedMap.newMapWith(INDEX_SETTING_COMPARATOR, (Pair[])new Pair[]{Tuples.pair((Object)DIMENSIONS, (Object)KernelVersion.VERSION_NODE_VECTOR_INDEX_INTRODUCED), Tuples.pair((Object)SIMILARITY_FUNCTION, (Object)KernelVersion.VERSION_NODE_VECTOR_INDEX_INTRODUCED), Tuples.pair((Object)QUANTIZATION_ENABLED, (Object)KernelVersion.VERSION_VECTOR_QUANTIZATION_AND_HYPER_PARAMS), Tuples.pair((Object)HNSW_M, (Object)KernelVersion.VERSION_VECTOR_QUANTIZATION_AND_HYPER_PARAMS), Tuples.pair((Object)HNSW_EF_CONSTRUCTION, (Object)KernelVersion.VERSION_VECTOR_QUANTIZATION_AND_HYPER_PARAMS)}).toImmutable();

    static ImmutableSortedMap<IndexSetting, Object> toValidSettings(RichIterable<IndexConfigValidationRecords.Valid> validRecords) {
        return validRecords.toSortedMap(Comparator.comparing(IndexSetting::getSettingName, String.CASE_INSENSITIVE_ORDER), IndexConfigValidationRecords.Valid::setting, IndexConfigValidationRecords.Valid::value).toImmutable();
    }

    static IndexConfig toIndexConfig(RichIterable<IndexConfigValidationRecords.Valid> validRecords) {
        return VectorIndexConfigUtils.toIndexConfig(validRecords, (Predicate<IndexConfigValidationRecords.Valid>)(Predicate & Serializable)valid -> true);
    }

    static IndexConfig toIndexConfig(RichIterable<IndexConfigValidationRecords.Valid> validRecords, RichIterable<String> validSettingNames) {
        return VectorIndexConfigUtils.toIndexConfig(validRecords, (Predicate<IndexConfigValidationRecords.Valid>)Predicates.attributeIn(IndexConfigValidationRecords.KnownSetting::settingName, validSettingNames));
    }

    static IndexConfig toIndexConfig(RichIterable<IndexConfigValidationRecords.Valid> validRecords, Predicate<IndexConfigValidationRecords.Valid> filter) {
        return IndexConfig.with((Map)validRecords.asLazy().select(filter).select((Predicate)Predicates.attributeNotNull(IndexConfigValidationRecords.Valid::stored)).select((Predicate)Predicates.attributeNotEqual(IndexConfigValidationRecords.Valid::stored, (Object)Values.NO_VALUE)).toMap((Function & Serializable)valid -> valid.setting().getSettingName(), IndexConfigValidationRecords.Valid::stored));
    }

    static void assertValidRecords(IndexConfigValidationRecords validationRecords, IndexProviderDescriptor descriptor, Iterable<String> validSettingNames) {
        IndexConfigValidationRecords.IndexConfigValidationRecord invalidRecord = (IndexConfigValidationRecords.IndexConfigValidationRecord)IndexConfigValidationRecords.State.INVALID_STATES.asLazy().flatCollect(arg_0 -> ((IndexConfigValidationRecords)validationRecords).get(arg_0)).getFirst();
        if (invalidRecord == null) {
            return;
        }
        String settingName = invalidRecord.settingName();
        throw switch (invalidRecord.state()) {
            default -> throw new MatchException(null, null);
            case IndexConfigValidationRecords.State.VALID -> InternalException.indexNotApplicable((String)descriptor.name(), (String)"%s should not be %s at this point. Provided: %s".formatted(IndexConfigValidationRecords.IndexConfigValidationRecord.class.getSimpleName(), IndexConfigValidationRecords.State.VALID, invalidRecord));
            case IndexConfigValidationRecords.State.PENDING -> InternalException.indexNotApplicable((String)descriptor.name(), (String)"Validation for '%s' is incomplete.".formatted(settingName));
            case IndexConfigValidationRecords.State.UNRECOGNIZED_SETTING -> IndexConfigValidationWrapper.unrecognizedSetting(invalidRecord.settingName(), validSettingNames);
            case IndexConfigValidationRecords.State.MISSING_SETTING -> InvalidArgumentException.missingIndexConfig((String)settingName);
            case IndexConfigValidationRecords.State.INCORRECT_TYPE -> {
                IndexConfigValidationRecords.IncorrectType incorrectType = (IndexConfigValidationRecords.IncorrectType)invalidRecord;
                yield InvalidArgumentException.invalidType((String)settingName, (String)incorrectType.rawValue().prettify(), (String)incorrectType.targetType().getSimpleName(), (String)incorrectType.rawValue().getTypeName());
            }
            case IndexConfigValidationRecords.State.INVALID_VALUE -> {
                IndexConfigValidationRecords.InvalidValue invalidValue = (IndexConfigValidationRecords.InvalidValue)invalidRecord;
                Object valid = invalidValue.valid();
                if (valid instanceof Range) {
                    Range range = (Range)valid;
                    Value actualRawValue = invalidValue.rawValue() != null ? invalidValue.rawValue() : Values.NO_VALUE;
                    yield InvalidArgumentException.outOfRange((String)settingName, (String)actualRawValue.prettify(), (String)actualRawValue.getTypeName(), (String)range.min().toString(), (String)range.max().toString());
                }
                if (valid instanceof Iterable || valid instanceof PrimitiveIterable) {
                    yield InvalidArgumentException.invalidIndexInput((String)invalidValue.rawValue().prettify(), (String)settingName, (String)"'%s' is an unsupported '%s'. Supported: %s".formatted(invalidValue.rawValue().prettify(), settingName, valid));
                }
                yield InternalException.indexNotApplicable((String)descriptor.name(), (String)"Unhandled valid value type '%s' for '%s'. Provided: %s");
            }
        };
    }

    public record Range<T extends Comparable<T>>(T min, T max) {
        public Range {
            Preconditions.checkArgument((((Comparable)Objects.requireNonNull(min)).compareTo((Comparable)Objects.requireNonNull(max)) <= 0 ? 1 : 0) != 0, (String)"min must be less than or equal to max");
        }

        public boolean contains(T value) {
            Objects.requireNonNull(value);
            return this.min.compareTo(value) <= 0 && this.max.compareTo(value) >= 0;
        }

        public boolean isBefore(T value) {
            Objects.requireNonNull(value);
            return value.compareTo(this.max) > 0;
        }

        public boolean isAfter(T value) {
            Objects.requireNonNull(value);
            return value.compareTo(this.min) < 0;
        }
    }
}

