/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.plandescription;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.Clause;
import org.neo4j.cypher.internal.ast.ConditionalQueryBranch;
import org.neo4j.cypher.internal.ast.ConditionalQueryWhen;
import org.neo4j.cypher.internal.ast.SingleQuery;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier$;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier$;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.Pattern;
import org.neo4j.cypher.internal.expressions.PatternElement;
import org.neo4j.cypher.internal.expressions.PatternPart;
import org.neo4j.cypher.internal.expressions.RelationshipPattern;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.AprioriScope;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.Declarations;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.ExpressionResult$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.ExpressionScope;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.NoResult$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.OmittedResult$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.PatternIncomingContext;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.PatternScope;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.RegularContext;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.Result;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.StatementScope;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.TableResult;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.TableResultWithNotYetKnownColumns$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.UnexpectedAstNodeScopingError;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.WorkingContext;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.WorkingScope;
import org.neo4j.cypher.internal.label_expressions.LabelExpression;
import org.neo4j.cypher.internal.plandescription.Argument;
import org.neo4j.cypher.internal.plandescription.Arguments;
import org.neo4j.cypher.internal.plandescription.InternalPlanDescription;
import org.neo4j.cypher.internal.plandescription.PrettyString;
import org.neo4j.cypher.internal.plandescription.PrettyString$;
import org.neo4j.cypher.internal.plandescription.WorkingScopePlanDescription;
import org.neo4j.cypher.internal.util.ASTNode;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InputPosition$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class WorkingScope2PlanDescription$ {
    public static final WorkingScope2PlanDescription$ MODULE$ = new WorkingScope2PlanDescription$();
    private static final Prettifier prettifier = new Prettifier(ExpressionStringifier$.MODULE$.apply(ExpressionStringifier$.MODULE$.apply$default$1(), ExpressionStringifier$.MODULE$.apply$default$2(), ExpressionStringifier$.MODULE$.apply$default$3(), ExpressionStringifier$.MODULE$.apply$default$4(), ExpressionStringifier$.MODULE$.apply$default$5()), Prettifier$.MODULE$.apply$default$2(), Prettifier$.MODULE$.apply$default$3());

    public InternalPlanDescription apply(WorkingScope workingScope) {
        return this.create(workingScope, 1);
    }

    private InternalPlanDescription create(WorkingScope workingScope, int inNum) {
        Tuple2 tuple2 = (Tuple2)workingScope.children().foldLeft((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)inNum), (Object)package$.MODULE$.Seq().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                WorkingScope thisWorkingScope = (WorkingScope)tuple2._2();
                if (tuple22 != null) {
                    int prevInNum = tuple22._1$mcI$sp();
                    Seq prevChildren = (Seq)tuple22._2();
                    int thisInNum = prevInNum + 1;
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)thisInNum), prevChildren.$colon$plus((Object)MODULE$.create(thisWorkingScope, thisInNum)));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq children = (Seq)tuple2._2();
        Seq children2 = children;
        WorkingScope workingScope2 = workingScope;
        if (workingScope2 instanceof StatementScope) {
            StatementScope statementScope = (StatementScope)workingScope2;
            ASTNode astNode = statementScope.astNode();
            RegularContext incoming = statementScope.incoming();
            Set referenced = statementScope.referenced();
            Declarations declared = statementScope.declared();
            RegularContext outgoing = statementScope.outgoing();
            Result result = statementScope.result();
            return new WorkingScopePlanDescription(inNum, this.renderAstString(astNode), this.renderVariables((WorkingContext)incoming), (Seq<Argument>)((Seq)new .colon.colon(this.renderIncoming((WorkingContext)incoming), (List)new .colon.colon(this.renderReferenced((Set<LogicalVariable>)referenced), (List)new .colon.colon(this.renderDeclaration(declared), (List)new .colon.colon(this.renderResult(result), (List)new .colon.colon(this.renderOutgoing(result, (WorkingContext)outgoing), (List)Nil$.MODULE$))))).flatten(Predef$.MODULE$.$conforms())), (Seq<InternalPlanDescription>)children2);
        }
        if (workingScope2 instanceof ExpressionScope) {
            ExpressionScope expressionScope = (ExpressionScope)workingScope2;
            ASTNode astNode = expressionScope.astNode();
            RegularContext incoming = expressionScope.incoming();
            Set referenced = expressionScope.referenced();
            Declarations declared = expressionScope.declared();
            return new WorkingScopePlanDescription(inNum, this.renderAstString(astNode), this.renderVariables((WorkingContext)incoming), (Seq<Argument>)((Seq)new .colon.colon(this.renderIncoming((WorkingContext)incoming), (List)new .colon.colon(this.renderReferenced((Set<LogicalVariable>)referenced), (List)new .colon.colon(this.renderDeclaration(declared), (List)Nil$.MODULE$))).flatten(Predef$.MODULE$.$conforms())), (Seq<InternalPlanDescription>)children2);
        }
        if (workingScope2 instanceof PatternScope) {
            PatternScope patternScope = (PatternScope)workingScope2;
            ASTNode astNode = patternScope.astNode();
            PatternIncomingContext patternIncoming = patternScope.patternIncoming();
            Set referenced = patternScope.referenced();
            Declarations declared = patternScope.declared();
            TableResult result = patternScope.result();
            return new WorkingScopePlanDescription(inNum, this.renderAstString(astNode), this.renderVariables((WorkingContext)patternIncoming), (Seq<Argument>)((Seq)new .colon.colon(this.renderIncoming((WorkingContext)patternIncoming), (List)new .colon.colon(this.renderReferenced((Set<LogicalVariable>)referenced), (List)new .colon.colon(this.renderDeclaration(declared), (List)new .colon.colon(this.renderResult((Result)result), (List)Nil$.MODULE$)))).flatten(Predef$.MODULE$.$conforms())), (Seq<InternalPlanDescription>)children2);
        }
        if (workingScope2 instanceof AprioriScope) {
            AprioriScope aprioriScope = (AprioriScope)workingScope2;
            RegularContext outgoing = aprioriScope.outgoing();
            return new WorkingScopePlanDescription(inNum, "apriori", (Set<PrettyString>)Predef$.MODULE$.Set().empty(), (Seq<Argument>)((Seq)new .colon.colon(this.renderOutgoingWorkingContext((WorkingContext)outgoing), (List)Nil$.MODULE$).flatten(Predef$.MODULE$.$conforms())), (Seq<InternalPlanDescription>)children2);
        }
        if (workingScope2 instanceof UnexpectedAstNodeScopingError) {
            UnexpectedAstNodeScopingError unexpectedAstNodeScopingError = (UnexpectedAstNodeScopingError)workingScope2;
            ASTNode astNode = unexpectedAstNodeScopingError.astNode();
            RegularContext incoming = unexpectedAstNodeScopingError.incoming();
            return new WorkingScopePlanDescription(inNum, this.renderAstString(astNode), this.renderVariables((WorkingContext)incoming), (Seq<Argument>)((Seq)new .colon.colon(this.renderIncoming((WorkingContext)incoming), (List)new .colon.colon((Object)new .colon.colon((Object)new Arguments.Comment("unexpected syntax"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)).flatten(Predef$.MODULE$.$conforms())), (Seq<InternalPlanDescription>)children2);
        }
        throw new MatchError((Object)workingScope2);
    }

    private Prettifier prettifier() {
        return prettifier;
    }

    private String renderAstString(ASTNode astNode) {
        Option option;
        boolean bl = false;
        ConditionalQueryBranch conditionalQueryBranch = null;
        ASTNode aSTNode = astNode;
        if (aSTNode instanceof Statement) {
            Statement statement = (Statement)aSTNode;
            return this.prettifier().asString(statement);
        }
        if (aSTNode instanceof Clause) {
            Clause clause = (Clause)aSTNode;
            return this.prettifier().asString((Statement)new SingleQuery((Seq)new .colon.colon((Object)clause, (List)Nil$.MODULE$), (InputPosition)InputPosition$.MODULE$.NONE()));
        }
        if (aSTNode instanceof Expression) {
            Expression expression = (Expression)aSTNode;
            return this.prettifier().expr().apply(expression);
        }
        if (aSTNode instanceof Pattern) {
            Pattern pattern = (Pattern)aSTNode;
            return this.prettifier().expr().patterns().apply(pattern);
        }
        if (aSTNode instanceof PatternPart) {
            PatternPart patternPart = (PatternPart)aSTNode;
            return this.prettifier().expr().patterns().apply(patternPart);
        }
        if (aSTNode instanceof PatternElement) {
            PatternElement patternElement = (PatternElement)aSTNode;
            return this.prettifier().expr().patterns().apply(patternElement);
        }
        if (aSTNode instanceof RelationshipPattern) {
            RelationshipPattern relationshipPattern = (RelationshipPattern)aSTNode;
            return this.prettifier().expr().patterns().apply(relationshipPattern);
        }
        if (aSTNode instanceof LabelExpression) {
            LabelExpression labelExpression = (LabelExpression)aSTNode;
            return this.prettifier().expr().stringifyLabelExpression(labelExpression);
        }
        if (aSTNode instanceof ConditionalQueryBranch) {
            bl = true;
            conditionalQueryBranch = (ConditionalQueryBranch)aSTNode;
            Option option2 = conditionalQueryBranch.predicate();
            if (option2 instanceof Some) {
                return this.prettifier().asString((Statement)new ConditionalQueryWhen((Seq)new .colon.colon((Object)conditionalQueryBranch, (List)Nil$.MODULE$), (Option)None$.MODULE$, (InputPosition)InputPosition$.MODULE$.NONE()));
            }
        }
        if (bl && None$.MODULE$.equals(option = conditionalQueryBranch.predicate())) {
            return this.prettifier().asString((Statement)new ConditionalQueryWhen((Seq)Nil$.MODULE$, (Option)new Some((Object)conditionalQueryBranch), (InputPosition)InputPosition$.MODULE$.NONE()));
        }
        return aSTNode.toString();
    }

    private Set<PrettyString> renderVariables(WorkingContext incoming) {
        return (Set)incoming.allSymbols().map((Function1 & Serializable)v -> PrettyString$.MODULE$.apply(v.name()));
    }

    private Seq<Argument> renderIncoming(WorkingContext incoming) {
        WorkingContext workingContext = incoming;
        if (workingContext instanceof RegularContext) {
            RegularContext regularContext = (RegularContext)workingContext;
            Set constants = regularContext.constants();
            Set variables = regularContext.variables();
            return new .colon.colon((Object)new Arguments.IncomingConstants(this.renderVariableSet((Set<LogicalVariable>)constants)), (List)new .colon.colon((Object)new Arguments.IncomingVariables(this.renderVariableSet((Set<LogicalVariable>)variables)), (List)Nil$.MODULE$));
        }
        if (workingContext instanceof PatternIncomingContext) {
            PatternIncomingContext patternIncomingContext = (PatternIncomingContext)workingContext;
            Set topology = patternIncomingContext.topologicalConstants();
            Set predicate = patternIncomingContext.predicateConstants();
            Set path = patternIncomingContext.pathConstants();
            return new .colon.colon((Object)new Arguments.IncomingTopology(this.renderVariableSet((Set<LogicalVariable>)topology)), (List)new .colon.colon((Object)new Arguments.IncomingPredicate(this.renderVariableSet((Set<LogicalVariable>)predicate)), (List)new .colon.colon((Object)new Arguments.IncomingPath(this.renderVariableSet((Set<LogicalVariable>)path)), (List)Nil$.MODULE$)));
        }
        throw new MatchError((Object)workingContext);
    }

    private Seq<Argument> renderDeclaration(Declarations declarations) {
        Declarations declarations2 = declarations;
        if (declarations2 != null) {
            Seq constants = declarations2.constants();
            Seq variables = declarations2.variables();
            if (constants.isEmpty() && variables.isEmpty()) {
                return (Seq)package$.MODULE$.Seq().empty();
            }
        }
        if (declarations2 != null) {
            Seq constants = declarations2.constants();
            Seq variables = declarations2.variables();
            return new .colon.colon((Object)new Arguments.DeclaredConstants(this.renderVariableSeq((Seq<LogicalVariable>)constants)), (List)new .colon.colon((Object)new Arguments.DeclaredVariables(this.renderVariableSeq((Seq<LogicalVariable>)variables)), (List)Nil$.MODULE$));
        }
        throw new MatchError((Object)declarations2);
    }

    private Seq<Argument> renderReferenced(Set<LogicalVariable> referenced) {
        return new .colon.colon((Object)new Arguments.Referenced(this.renderVariableSet(referenced)), (List)Nil$.MODULE$);
    }

    private Seq<Argument> renderResult(Result result) {
        Result result2 = result;
        if (result2 instanceof TableResult) {
            TableResult tableResult = (TableResult)result2;
            Seq columns = tableResult.columns();
            return new .colon.colon((Object)new Arguments.ResultColumns(this.renderVariableSeq((Seq<LogicalVariable>)columns)), (List)Nil$.MODULE$);
        }
        if (TableResultWithNotYetKnownColumns$.MODULE$.equals(result2)) {
            return new .colon.colon((Object)new Arguments.ResultColumns("- Not yet known columns -"), (List)Nil$.MODULE$);
        }
        if (OmittedResult$.MODULE$.equals(result2)) {
            return new .colon.colon((Object)new Arguments.ResultColumns("- Omitted -"), (List)Nil$.MODULE$);
        }
        if (NoResult$.MODULE$.equals(result2)) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        if (ExpressionResult$.MODULE$.equals(result2)) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        throw new MatchError((Object)result2);
    }

    private Seq<Argument> renderOutgoing(Result result, WorkingContext outgoing) {
        Result result2 = result;
        if (result2 instanceof TableResult) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        if (TableResultWithNotYetKnownColumns$.MODULE$.equals(result2)) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        if (OmittedResult$.MODULE$.equals(result2)) {
            return this.renderOutgoingWorkingContext(outgoing);
        }
        if (NoResult$.MODULE$.equals(result2)) {
            return this.renderOutgoingWorkingContext(outgoing);
        }
        if (ExpressionResult$.MODULE$.equals(result2)) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        throw new MatchError((Object)result2);
    }

    private Seq<Argument> renderOutgoingWorkingContext(WorkingContext outgoing) {
        WorkingContext workingContext = outgoing;
        if (workingContext instanceof RegularContext) {
            RegularContext regularContext = (RegularContext)workingContext;
            Set constants = regularContext.constants();
            Set variables = regularContext.variables();
            return new .colon.colon((Object)new Arguments.OutgoingConstants(this.renderVariableSet((Set<LogicalVariable>)constants)), (List)new .colon.colon((Object)new Arguments.OutgoingVariables(this.renderVariableSet((Set<LogicalVariable>)variables)), (List)Nil$.MODULE$));
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private String renderVariableSet(Set<LogicalVariable> variables) {
        return ((IterableOnceOps)((IterableOps)variables.toSeq().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)WorkingScope2PlanDescription$.$anonfun$renderVariableSet$1(x$1)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)variable -> MODULE$.renderVariable((LogicalVariable)variable))).mkString(", ");
    }

    private String renderVariableSeq(Seq<LogicalVariable> variables) {
        return ((IterableOnceOps)variables.map((Function1 & Serializable)variable -> MODULE$.renderVariable((LogicalVariable)variable))).mkString(", ");
    }

    private String renderVariable(LogicalVariable variable) {
        return variable.name();
    }

    public static final /* synthetic */ int $anonfun$renderVariableSet$1(LogicalVariable x$1) {
        return x$1.position().offset();
    }

    private WorkingScope2PlanDescription$() {
    }
}

