/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi;

import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.planner.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.spi.MinimumGraphStatistics;
import org.neo4j.cypher.internal.spi.TransactionBoundGraphStatistics;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.cypher.internal.util.Selectivity$;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLog;
import scala.MatchError;
import scala.Option;
import scala.Some;

public final class TransactionBoundGraphStatistics$ {
    public static final TransactionBoundGraphStatistics$ MODULE$ = new TransactionBoundGraphStatistics$();

    public MinimumGraphStatistics apply(TransactionalContext transactionalContext, InternalLog log) {
        return this.apply(transactionalContext.kernelTransaction().dataRead(), transactionalContext.kernelTransaction().schemaRead(), log);
    }

    public MinimumGraphStatistics apply(Read read, SchemaRead schemaRead, InternalLog log) {
        return new MinimumGraphStatistics((GraphStatistics)new TransactionBoundGraphStatistics.BaseTransactionBoundGraphStatistics(read, schemaRead, log));
    }

    public Option<Selectivity> uniqueValueSelectivity(IndexDescriptor indexDescriptor, SchemaRead schemaRead) {
        long indexSize = schemaRead.indexSize(indexDescriptor);
        if (indexSize == 0L) {
            return new Some((Object)Selectivity$.MODULE$.ZERO());
        }
        double indexEntrySelectivity = schemaRead.indexUniqueValuesSelectivity(indexDescriptor);
        if (indexEntrySelectivity == 0.0) {
            return new Some((Object)Selectivity$.MODULE$.ZERO());
        }
        double frequencyOfEntitiesWithSameValue = 1.0 / indexEntrySelectivity;
        double indexSelectivity = frequencyOfEntitiesWithSameValue / (double)indexSize;
        return Selectivity$.MODULE$.of(Math.min(indexSelectivity, 1.0));
    }

    public Option<Selectivity> indexPropertyIsNotNullSelectivity(IndexDescriptor indexDescriptor, Read read, SchemaRead schemaRead) {
        double d;
        EntityType entityType = indexDescriptor.schema().entityType();
        if (EntityType.NODE.equals(entityType)) {
            d = read.estimateCountsForNode(indexDescriptor.schema().getLabelId());
        } else if (EntityType.RELATIONSHIP.equals(entityType)) {
            d = read.estimateCountsForRelationships(-1, indexDescriptor.schema().getRelTypeId(), -1);
        } else {
            throw new MatchError((Object)entityType);
        }
        double entitiesCount = d;
        if (entitiesCount == 0.0) {
            return new Some((Object)Selectivity$.MODULE$.ZERO());
        }
        long indexSize = schemaRead.indexSize(indexDescriptor);
        double indexSelectivity = (double)indexSize / entitiesCount;
        return Selectivity$.MODULE$.of(Math.min(indexSelectivity, 1.0));
    }

    private TransactionBoundGraphStatistics$() {
    }
}

