/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.forseti;

import org.neo4j.kernel.impl.locking.forseti.ForsetiClient;
import org.neo4j.kernel.impl.locking.forseti.ForsetiLockManager;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceType;

record LockPath(ForsetiClient owner, long ownerTransactionId, ForsetiLockManager.Lock ownerWaitingForLock, ResourceType ownerWaitingForResourceType, long ownerWaitingForResourceId, LockType ownerWaitingForLockType, LockPath parent) {
    boolean containsOwner(long otherOwnerTransactionId) {
        LockPath path = this;
        while (path != null) {
            if (path.ownerTransactionId == otherOwnerTransactionId) {
                return true;
            }
            path = path.parent;
        }
        return false;
    }

    private LockPath reverse() {
        LockPath reversed = null;
        LockPath path = this;
        while (path != null) {
            reversed = new LockPath(path.owner, path.ownerTransactionId, path.ownerWaitingForLock, path.ownerWaitingForResourceType, path.ownerWaitingForResourceId, path.ownerWaitingForLockType, reversed);
            path = path.parent;
        }
        return reversed;
    }

    String stringify(ForsetiLockManager.Lock lock, ResourceType resourceType, long resourceId) {
        StringBuilder builder = new StringBuilder();
        LockPath path = this.reverse();
        LockType lockType = lock.type();
        builder.append(ForsetiClient.lockString(resourceType, resourceId));
        while (path != null) {
            if (path.owner.transactionId() != path.ownerTransactionId || !path.owner.isWaitingFor(path.ownerWaitingForLock, path.ownerWaitingForResourceType, path.ownerWaitingForResourceId)) {
                return null;
            }
            builder.append(String.format("-[%s_OWNER]->(tx:%d)-[WAITING_FOR_%s]->(%s)", new Object[]{lockType, path.ownerTransactionId, path.ownerWaitingForLockType, ForsetiClient.lockString(path.ownerWaitingForResourceType, path.ownerWaitingForResourceId)}));
            lockType = path.ownerWaitingForLock.type();
            path = path.parent;
        }
        return builder.toString();
    }
}

