/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.indexcommand;

import java.io.IOException;
import org.neo4j.internal.indexcommand.IndexCommandSerialization;
import org.neo4j.internal.indexcommand.TokenIndexUpdateCommand;
import org.neo4j.internal.indexcommand.ValueIndexUpdateCommand;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.string.Mask;

public abstract sealed class IndexUpdateCommand<T>
implements StorageCommand
permits TokenIndexUpdateCommand, ValueIndexUpdateCommand {
    protected final UpdateMode updateMode;
    protected final long indexId;
    protected final long entityId;
    private final IndexCommandSerialization serialization;

    public IndexUpdateCommand(IndexCommandSerialization serialization, UpdateMode updateMode, long indexId, long entityId) {
        this.serialization = serialization;
        this.updateMode = updateMode;
        this.indexId = indexId;
        this.entityId = entityId;
    }

    public KernelVersion kernelVersion() {
        return this.serialization.kernelVersion();
    }

    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public abstract T getBefore();

    public abstract T getAfter();

    public String toString() {
        return this.toString(Mask.NO);
    }

    public abstract String toString(Mask var1);

    public void serialize(WritableChannel channel) throws IOException {
        this.serialization.writeIndexUpdateCommand(channel, this);
    }
}

