/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.indexcommand;

import java.util.Arrays;
import java.util.Objects;
import org.neo4j.internal.indexcommand.IndexCommandSerialization;
import org.neo4j.internal.indexcommand.IndexUpdateCommand;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.string.Mask;
import org.neo4j.values.storable.Value;

public final class ValueIndexUpdateCommand
extends IndexUpdateCommand<Value[]> {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ValueIndexUpdateCommand.class);
    private final Value[] before;
    private final Value[] values;

    public ValueIndexUpdateCommand(IndexCommandSerialization serialization, UpdateMode updateMode, long indexId, long entityId, Value[] before, Value[] values) {
        super(serialization, updateMode, indexId, entityId);
        this.before = before;
        this.values = values;
    }

    @Override
    public Value[] getBefore() {
        return this.before;
    }

    @Override
    public Value[] getAfter() {
        return this.values;
    }

    @Override
    public String toString(Mask mask) {
        return String.format("ValueIndexUpdateCommand[mode:%s, indexId:%d, entityId:%d, before:%s, after:%s]", this.updateMode, this.indexId, this.entityId, Arrays.toString(this.before), Arrays.toString(this.values));
    }

    public boolean equals(Object o) {
        if (!(o instanceof ValueIndexUpdateCommand)) {
            return false;
        }
        ValueIndexUpdateCommand that = (ValueIndexUpdateCommand)o;
        return Arrays.equals(this.before, that.before) && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.before), Arrays.hashCode(this.values));
    }
}

