/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class SyntaxException
extends Neo4jException {
    private final transient Integer offset;
    private final String query;
    private String positionString = "";
    public static final String QUOTE_MISMATCH_ERROR_MESSAGE = "Failed to parse string literal. The query must contain an even number of non-escaped quotes.";

    protected SyntaxException(ErrorGqlStatusObject gqlStatusObject, String message, String query, Integer offset, Throwable cause) {
        super(gqlStatusObject, message, cause);
        this.offset = offset;
        this.query = query;
    }

    public SyntaxException(ErrorGqlStatusObject gqlStatusObject, String message, String query, int offset) {
        this(gqlStatusObject, message, query, offset, null);
    }

    public SyntaxException(ErrorGqlStatusObject gqlStatusObject, String message, String query, String adjustedPosition, int offset) {
        this(gqlStatusObject, message, query, offset, null);
        if (Objects.nonNull(adjustedPosition)) {
            this.positionString = String.format(" (%s)", adjustedPosition);
        }
    }

    protected SyntaxException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        this(gqlStatusObject, message, "", null, cause);
    }

    public SyntaxException(ErrorGqlStatusObject gqlStatusObject, String message) {
        this(gqlStatusObject, message, "", null, null);
    }

    public static SyntaxException internalError(String msgTitle, String message, String query, int offset) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new SyntaxException(gql, message, query, offset, null);
    }

    public static SyntaxException internalError(String msgTitle, String message) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new SyntaxException(gql, message);
    }

    public static SyntaxException invalidShortestPathException(String start) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N33).build()).build();
        return new SyntaxException(gql, String.format("To find a shortest path, both ends of the path need to be provided. Couldn't find `%s`", start));
    }

    public static SyntaxException invalidInput(String input, List<String> expected, String legacyMessage, Integer offset) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I06).withParam(GqlParams.StringParam.input, input).withParam(GqlParams.ListParam.valueList, expected).build()).build();
        return new SyntaxException(gql, legacyMessage, input, offset);
    }

    public static SyntaxException wrongNumberOfArguments(int expectedCount, int actualCount, String name, String signature, String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I13).withParam(GqlParams.NumberParam.count1, (Number)expectedCount).withParam(GqlParams.NumberParam.count2, (Number)actualCount).withParam(GqlParams.StringParam.procFun, name).withParam(GqlParams.StringParam.sig, signature).build()).build();
        return new SyntaxException(gql, legacyMessage);
    }

    public static SyntaxException variableAlreadyBound(String variable, String clause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N78).withParam(GqlParams.StringParam.variable, variable).withParam(GqlParams.StringParam.clause, clause).build();
        return new SyntaxException(gql, String.format("Can't create node `%s` with labels or properties here. The variable is already declared in this context", variable));
    }

    public static SyntaxException accessingMultipleGraphsOnlySupportedOnCompositeDatabases(String legacyMessage, String query, int offset) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NA5).build()).build();
        return new SyntaxException(gql, legacyMessage, query, offset);
    }

    public static SyntaxException invalidNestedUseClause(String db1, String db2, String legacyMessage, String query, int offset) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N74).withParam(GqlParams.StringParam.db1, db1).withParam(GqlParams.StringParam.db2, db2).build()).build();
        return new SyntaxException(gql, legacyMessage, query, offset);
    }

    public static SyntaxException stringLiteralWithInvalidQuotes() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I19).build()).build();
        return new SyntaxException(gql, QUOTE_MISMATCH_ERROR_MESSAGE);
    }

    public static SyntaxException cannotYieldFromVoidProcedure() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I42).build()).build();
        return new SyntaxException(gql, "Cannot yield value from void procedure.");
    }

    public static SyntaxException unknownFunction(String functionName, int offset, int line, int column) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N48((String)functionName, (int)offset, (int)line, (int)column);
        return new SyntaxException(gql, String.format("Unknown function '%s'", functionName));
    }

    public static SyntaxException dynamicGraphReferenceUnsupported(String legacyMsg, String query, int offset, int line, int column) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N72((int)offset, (int)line, (int)column);
        return new SyntaxException(gql, legacyMsg, query, offset);
    }

    public static SyntaxException invalidUseOfAggregateFunction(String functionType, String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N34).withParam(GqlParams.StringParam.funType, functionType).build()).build();
        return new SyntaxException(gql, legacyMessage);
    }

    public static SyntaxException invalidPartInPBAC(String expression, String invalidPart) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NA0).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NAA).withParam(GqlParams.StringParam.expr, expression).withParam(GqlParams.StringParam.exprType, invalidPart).build()).build();
        return new SyntaxException(gql, String.format("The expression: `%s` is not supported. Lists containing %s values can not be used for property-based access control.", expression, invalidPart));
    }

    public static SyntaxException mixedListInPBAC(String expression) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NA0).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NAB).withParam(GqlParams.StringParam.expr, expression).build()).build();
        return new SyntaxException(gql, String.format("The expression: `%s` is not supported. All elements in a list must be literals of the same type for property-based access control.", expression));
    }

    public Status status() {
        return Status.Statement.SyntaxError;
    }

    public Optional<Integer> getOffset() {
        return Optional.ofNullable(this.offset);
    }

    public String getMessage() {
        return this.formatMessageWithPositionQueryAndOffset(super.getMessage());
    }

    public String legacyMessage() {
        return this.formatMessageWithPositionQueryAndOffset(super.legacyMessage());
    }

    public String formatMessageWithPositionQueryAndOffset(String message) {
        if (Objects.nonNull(this.offset)) {
            String[] stringArray;
            String[] split = this.query.split("\n");
            String string = System.lineSeparator();
            int n = this.offset;
            if (split.length != 0) {
                stringArray = split;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            }
            return message + this.positionString + string + SyntaxException.findErrorLine(n, stringArray);
        }
        return message;
    }

    public static String findErrorLine(int offset, String[] message) {
        int currentOffset = offset;
        if (message.length == 0) {
            throw new IllegalArgumentException("message converted to empty list");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < message.length; ++i) {
            String element = message[i];
            if (i < message.length - 1) {
                if (element.length() >= currentOffset) {
                    SyntaxException.buildErrorString(builder, element, currentOffset);
                    break;
                }
                currentOffset -= element.length() + 1;
                continue;
            }
            SyntaxException.buildErrorString(builder, element, Math.min(element.length(), currentOffset));
        }
        return builder.toString();
    }

    private static void buildErrorString(StringBuilder builder, String element, int currentOffset) {
        builder.append("\"").append(element.stripTrailing()).append("\"").append(System.lineSeparator()).append(" ".repeat(currentOffset + 1)).append('^');
    }
}

