/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.driver.Query;
import org.neo4j.driver.Result;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.internal.AbstractQueryRunner;
import org.neo4j.driver.internal.InternalResult;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.observation.DriverObservationProvider;
import org.neo4j.driver.internal.observation.Observation;
import org.neo4j.driver.internal.observation.util.ObservationUtil;
import org.neo4j.driver.internal.util.Futures;

public class InternalTransaction
extends AbstractQueryRunner
implements Transaction {
    private final UnmanagedTransaction tx;
    private final DriverObservationProvider observationProvider;
    private final Observation parentObservation;

    public InternalTransaction(UnmanagedTransaction tx, DriverObservationProvider observationProvider, Observation parentObservation) {
        this.tx = tx;
        this.observationProvider = Objects.requireNonNull(observationProvider);
        this.parentObservation = parentObservation;
    }

    @Override
    public void commit() {
        InternalTransaction.observeWithParentOrSupplier(this.parentObservation, () -> this.observationProvider.transactionCommit(Transaction.class), observation -> Futures.blockingGet(this.tx.commitAsync((Observation)observation), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while committing the transaction")));
    }

    @Override
    public void rollback() {
        InternalTransaction.observeWithParentOrSupplier(this.parentObservation, () -> this.observationProvider.transactionRollback(Transaction.class), observation -> Futures.blockingGet(this.tx.rollbackAsync((Observation)observation), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while rolling back the transaction")));
    }

    @Override
    public void close() {
        InternalTransaction.observeWithParentOrSupplier(this.parentObservation, () -> this.observationProvider.transactionClose(Transaction.class), observation -> Futures.blockingGet(this.tx.closeAsync((Observation)observation), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while closing the transaction")));
    }

    @Override
    public Result run(Query query) {
        Observation runObservation = this.observationProvider.transactionRun(Transaction.class, query.text(), query.parameters());
        return ObservationUtil.observe(runObservation, () -> {
            ResultCursor cursor = Futures.blockingGet(this.tx.runAsync(query, runObservation, Result.class), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while running query in transaction"));
            return new InternalResult(null, cursor);
        });
    }

    @Override
    public boolean isOpen() {
        return this.tx.isOpen();
    }

    public void terminate() {
        Futures.blockingGet(this.tx.terminateAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while terminating the transaction"));
    }

    private void terminateConnectionOnThreadInterrupt(String reason) {
        this.tx.connection().forceClose(reason);
    }

    private static void observeWithParentOrSupplier(Observation parentObservation, Supplier<Observation> observationSupplier, Consumer<Observation> runnable) {
        if (parentObservation != null) {
            runnable.accept(parentObservation);
        } else {
            Observation observation = observationSupplier.get();
            ObservationUtil.observe(observation, () -> runnable.accept(observation));
        }
    }
}

