/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.adaptedbolt;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.summary.BeginSummary;
import org.neo4j.bolt.connection.summary.CommitSummary;
import org.neo4j.bolt.connection.summary.DiscardSummary;
import org.neo4j.bolt.connection.summary.LogoffSummary;
import org.neo4j.bolt.connection.summary.LogonSummary;
import org.neo4j.bolt.connection.summary.ResetSummary;
import org.neo4j.bolt.connection.summary.RollbackSummary;
import org.neo4j.bolt.connection.summary.RouteSummary;
import org.neo4j.bolt.connection.summary.RunSummary;
import org.neo4j.bolt.connection.summary.TelemetrySummary;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.adaptedbolt.DriverResponseHandler;
import org.neo4j.driver.internal.adaptedbolt.ErrorMapper;
import org.neo4j.driver.internal.adaptedbolt.summary.PullSummary;
import org.neo4j.driver.internal.observation.BoltHandleObservation;
import org.neo4j.driver.internal.value.BoltValueFactory;

final class AdaptingDriverResponseHandler
implements ResponseHandler {
    private final DriverResponseHandler delegate;
    private final ErrorMapper errorMapper;
    private final BoltValueFactory boltValueFactory;
    private final BoltHandleObservation observation;

    AdaptingDriverResponseHandler(DriverResponseHandler delegate, ErrorMapper errorMapper, BoltValueFactory boltValueFactory, BoltHandleObservation observation) {
        this.delegate = Objects.requireNonNull(delegate);
        this.errorMapper = Objects.requireNonNull(errorMapper);
        this.boltValueFactory = Objects.requireNonNull(boltValueFactory);
        this.observation = Objects.requireNonNull(observation);
    }

    public void onError(Throwable throwable) {
        throwable = this.errorMapper.map(throwable);
        this.observation.error(throwable);
        this.delegate.onError(throwable);
    }

    public void onBeginSummary(BeginSummary summary) {
        this.observation.onSummary("BEGIN");
        this.delegate.onBeginSummary(summary);
    }

    public void onRunSummary(RunSummary summary) {
        this.observation.onSummary("RUN");
        this.delegate.onRunSummary(summary);
    }

    public void onRecord(List<org.neo4j.bolt.connection.values.Value> fields) {
        this.delegate.onRecord(this.boltValueFactory.toDriverList(fields));
    }

    public void onPullSummary(final org.neo4j.bolt.connection.summary.PullSummary summary) {
        this.observation.onSummary("PULL");
        this.delegate.onPullSummary(new PullSummary(){

            @Override
            public boolean hasMore() {
                return summary.hasMore();
            }

            @Override
            public Map<String, Value> metadata() {
                return AdaptingDriverResponseHandler.this.boltValueFactory.toDriverMap(summary.metadata());
            }
        });
    }

    public void onDiscardSummary(DiscardSummary summary) {
        this.observation.onSummary("DISCARD");
        this.delegate.onDiscardSummary(() -> this.boltValueFactory.toDriverMap(summary.metadata()));
    }

    public void onCommitSummary(CommitSummary summary) {
        this.observation.onSummary("COMMIT");
        this.delegate.onCommitSummary(summary);
    }

    public void onRollbackSummary(RollbackSummary summary) {
        this.observation.onSummary("ROLLBACK");
        this.delegate.onRollbackSummary(summary);
    }

    public void onResetSummary(ResetSummary summary) {
        this.observation.onSummary("RESET");
        this.delegate.onResetSummary(summary);
    }

    public void onRouteSummary(RouteSummary summary) {
        this.observation.onSummary("ROUTE");
        this.delegate.onRouteSummary(summary);
    }

    public void onLogoffSummary(LogoffSummary summary) {
        this.observation.onSummary("LOGOFF");
        this.delegate.onLogoffSummary(summary);
    }

    public void onLogonSummary(LogonSummary summary) {
        this.observation.onSummary("LOGON");
        this.delegate.onLogonSummary(summary);
    }

    public void onTelemetrySummary(TelemetrySummary summary) {
        this.observation.onSummary("TELEMETRY");
        this.delegate.onTelemetrySummary(summary);
    }

    public void onIgnored() {
        this.observation.onIgnored();
        this.delegate.onIgnored();
    }

    public void onComplete() {
        this.observation.stop();
        this.delegate.onComplete();
    }
}

