/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.types;

import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.types.TypeRepresentation;
import org.neo4j.driver.types.Type;
import org.neo4j.driver.types.TypeSystem;

public class InternalTypeSystem
implements TypeSystem {
    public static final InternalTypeSystem TYPE_SYSTEM = new InternalTypeSystem();
    private final TypeRepresentation anyType = this.constructType(TypeConstructor.ANY);
    private final TypeRepresentation booleanType = this.constructType(TypeConstructor.BOOLEAN);
    private final TypeRepresentation bytesType = this.constructType(TypeConstructor.BYTES);
    private final TypeRepresentation stringType = this.constructType(TypeConstructor.STRING);
    private final TypeRepresentation numberType = this.constructType(TypeConstructor.NUMBER);
    private final TypeRepresentation integerType = this.constructType(TypeConstructor.INTEGER);
    private final TypeRepresentation floatType = this.constructType(TypeConstructor.FLOAT);
    private final TypeRepresentation listType = this.constructType(TypeConstructor.LIST);
    private final TypeRepresentation mapType = this.constructType(TypeConstructor.MAP);
    private final TypeRepresentation nodeType = this.constructType(TypeConstructor.NODE);
    private final TypeRepresentation relationshipType = this.constructType(TypeConstructor.RELATIONSHIP);
    private final TypeRepresentation pathType = this.constructType(TypeConstructor.PATH);
    private final TypeRepresentation pointType = this.constructType(TypeConstructor.POINT);
    private final TypeRepresentation dateType = this.constructType(TypeConstructor.DATE);
    private final TypeRepresentation timeType = this.constructType(TypeConstructor.TIME);
    private final TypeRepresentation localTimeType = this.constructType(TypeConstructor.LOCAL_TIME);
    private final TypeRepresentation localDateTimeType = this.constructType(TypeConstructor.LOCAL_DATE_TIME);
    private final TypeRepresentation dateTimeType = this.constructType(TypeConstructor.DATE_TIME);
    private final TypeRepresentation durationType = this.constructType(TypeConstructor.DURATION);
    private final TypeRepresentation nullType = this.constructType(TypeConstructor.NULL);
    private final TypeRepresentation vectorType = this.constructType(TypeConstructor.VECTOR);
    private final TypeRepresentation unsupportedType = this.constructType(TypeConstructor.UNSUPPORTED);

    private InternalTypeSystem() {
    }

    @Override
    public Type ANY() {
        return this.anyType;
    }

    @Override
    public Type BOOLEAN() {
        return this.booleanType;
    }

    @Override
    public Type BYTES() {
        return this.bytesType;
    }

    @Override
    public Type STRING() {
        return this.stringType;
    }

    @Override
    public Type NUMBER() {
        return this.numberType;
    }

    @Override
    public Type INTEGER() {
        return this.integerType;
    }

    @Override
    public Type FLOAT() {
        return this.floatType;
    }

    @Override
    public Type LIST() {
        return this.listType;
    }

    @Override
    public Type MAP() {
        return this.mapType;
    }

    @Override
    public Type NODE() {
        return this.nodeType;
    }

    @Override
    public Type RELATIONSHIP() {
        return this.relationshipType;
    }

    @Override
    public Type PATH() {
        return this.pathType;
    }

    @Override
    public Type POINT() {
        return this.pointType;
    }

    @Override
    public Type DATE() {
        return this.dateType;
    }

    @Override
    public Type TIME() {
        return this.timeType;
    }

    @Override
    public Type LOCAL_TIME() {
        return this.localTimeType;
    }

    @Override
    public Type LOCAL_DATE_TIME() {
        return this.localDateTimeType;
    }

    @Override
    public Type DATE_TIME() {
        return this.dateTimeType;
    }

    @Override
    public Type DURATION() {
        return this.durationType;
    }

    @Override
    public Type NULL() {
        return this.nullType;
    }

    @Override
    public Type VECTOR() {
        return this.vectorType;
    }

    @Override
    public Type UNSUPPORTED() {
        return this.unsupportedType;
    }

    private TypeRepresentation constructType(TypeConstructor tyCon) {
        return new TypeRepresentation(tyCon);
    }
}

