/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.values.Node;
import org.neo4j.bolt.connection.values.Path;
import org.neo4j.bolt.connection.values.Segment;
import org.neo4j.bolt.connection.values.Type;
import org.neo4j.bolt.connection.values.ValueFactory;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.InternalRelationship;
import org.neo4j.driver.internal.InternalUnsupportedType;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.UnsupportedDateTimeValue;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;

public class BoltValueFactory
implements ValueFactory {
    private static final BoltValueFactory INSTANCE = new BoltValueFactory();

    public static BoltValueFactory getInstance() {
        return INSTANCE;
    }

    private BoltValueFactory() {
    }

    public org.neo4j.bolt.connection.values.Value value(Object value) {
        return (InternalValue)Values.value(value);
    }

    public org.neo4j.bolt.connection.values.Value value(boolean value) {
        return (InternalValue)Values.value(value);
    }

    public org.neo4j.bolt.connection.values.Value value(long value) {
        return (InternalValue)Values.value(value);
    }

    public org.neo4j.bolt.connection.values.Value value(double value) {
        return (InternalValue)Values.value(value);
    }

    public org.neo4j.bolt.connection.values.Value value(byte[] values) {
        if (values == null) {
            return this.value((Object)null);
        }
        return (InternalValue)Values.value(values);
    }

    public org.neo4j.bolt.connection.values.Value value(String value) {
        if (value == null) {
            return this.value((Object)null);
        }
        return (InternalValue)Values.value(value);
    }

    public org.neo4j.bolt.connection.values.Value value(Map<String, org.neo4j.bolt.connection.values.Value> stringToValue) {
        if (stringToValue == null) {
            return this.value((Object)null);
        }
        return new MapValue(stringToValue);
    }

    public org.neo4j.bolt.connection.values.Value value(List<org.neo4j.bolt.connection.values.Value> values) {
        if (values == null) {
            return this.value((Object)null);
        }
        return new ListValue(values);
    }

    public org.neo4j.bolt.connection.values.Value value(Node node) {
        if (node == null) {
            return this.value((Object)null);
        }
        return (InternalValue)((InternalNode)node).asValue();
    }

    public org.neo4j.bolt.connection.values.Value value(org.neo4j.bolt.connection.values.Relationship relationship) {
        if (relationship == null) {
            return this.value((Object)null);
        }
        return (InternalValue)((InternalRelationship)relationship).asValue();
    }

    public org.neo4j.bolt.connection.values.Value value(Path path) {
        if (path == null) {
            return this.value((Object)null);
        }
        return (InternalValue)((InternalPath)path).asValue();
    }

    public org.neo4j.bolt.connection.values.Value value(LocalDate localDate) {
        if (localDate == null) {
            return this.value((Object)null);
        }
        return (InternalValue)Values.value(localDate);
    }

    public org.neo4j.bolt.connection.values.Value value(OffsetTime offsetTime) {
        if (offsetTime == null) {
            return this.value((Object)null);
        }
        return (InternalValue)Values.value(offsetTime);
    }

    public org.neo4j.bolt.connection.values.Value value(LocalTime localTime) {
        if (localTime == null) {
            return this.value((Object)null);
        }
        return (InternalValue)Values.value(localTime);
    }

    public org.neo4j.bolt.connection.values.Value value(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return this.value((Object)null);
        }
        return (InternalValue)Values.value(localDateTime);
    }

    public org.neo4j.bolt.connection.values.Value value(OffsetDateTime offsetDateTime) {
        if (offsetDateTime == null) {
            return this.value((Object)null);
        }
        return (InternalValue)Values.value(offsetDateTime);
    }

    public org.neo4j.bolt.connection.values.Value value(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return this.value((Object)null);
        }
        return (InternalValue)Values.value(zonedDateTime);
    }

    public org.neo4j.bolt.connection.values.Value value(Period period) {
        if (period == null) {
            return this.value((Object)null);
        }
        return (InternalValue)Values.value(period);
    }

    public org.neo4j.bolt.connection.values.Value value(Duration duration) {
        if (duration == null) {
            return this.value((Object)null);
        }
        return (InternalValue)Values.value(duration);
    }

    public Node node(long id, String elementId, Collection<String> labels, Map<String, org.neo4j.bolt.connection.values.Value> properties) {
        return new InternalNode(id, elementId, labels, this.toDriverMap(properties));
    }

    public org.neo4j.bolt.connection.values.Relationship relationship(long id, String elementId, long start, String startElementId, long end, String endElementId, String type, Map<String, org.neo4j.bolt.connection.values.Value> properties) {
        return new InternalRelationship(id, elementId, start, startElementId, end, endElementId, type, this.toDriverMap(properties));
    }

    public Segment segment(Node start, org.neo4j.bolt.connection.values.Relationship relationship, Node end) {
        return new InternalPath.SelfContainedSegment((InternalNode)start, (InternalRelationship)relationship, (InternalNode)end);
    }

    public Path path(List<Segment> segments, List<Node> nodes, List<org.neo4j.bolt.connection.values.Relationship> relationships) {
        List<Path.Segment> segments0 = segments.stream().map(segment -> (Path.Segment)segment).toList();
        List<org.neo4j.driver.types.Node> nodes0 = nodes.stream().map(node -> (org.neo4j.driver.types.Node)node).toList();
        List<Relationship> relationships0 = relationships.stream().map(relationship -> (Relationship)relationship).toList();
        return new InternalPath(segments0, nodes0, relationships0);
    }

    public org.neo4j.bolt.connection.values.Value isoDuration(long months, long days, long seconds, int nanoseconds) {
        return (InternalValue)Values.isoDuration(months, days, seconds, nanoseconds);
    }

    public org.neo4j.bolt.connection.values.Value point(int srid, double x, double y) {
        return (InternalValue)Values.point(srid, x, y);
    }

    public org.neo4j.bolt.connection.values.Value point(int srid, double x, double y, double z) {
        return (InternalValue)Values.point(srid, x, y, z);
    }

    public org.neo4j.bolt.connection.values.Value vector(Class<?> elementType, Object elements) {
        InternalValue value;
        if (elements.getClass().equals(byte[].class)) {
            value = (InternalValue)Values.vector((byte[])elements);
        } else if (elements.getClass().equals(short[].class)) {
            value = (InternalValue)Values.vector((short[])elements);
        } else if (elements.getClass().equals(int[].class)) {
            value = (InternalValue)Values.vector((int[])elements);
        } else if (elements.getClass().equals(long[].class)) {
            value = (InternalValue)Values.vector((long[])elements);
        } else if (elements.getClass().equals(float[].class)) {
            value = (InternalValue)Values.vector((float[])elements);
        } else if (elements.getClass().equals(double[].class)) {
            value = (InternalValue)Values.vector((double[])elements);
        } else {
            throw new AssertionError((Object)("Unsupported type: " + String.valueOf(elements.getClass())));
        }
        return value;
    }

    public org.neo4j.bolt.connection.values.Value unsupportedType(String name, BoltProtocolVersion minBoltVersion, Map<String, org.neo4j.bolt.connection.values.Value> extra) {
        org.neo4j.bolt.connection.values.Value message = extra.get("message");
        String messageString = message != null ? (message.boltValueType().equals((Object)Type.STRING) ? message.asString() : null) : null;
        return (InternalValue)Values.value((Object)new InternalUnsupportedType(name, minBoltVersion.toString(), messageString));
    }

    public org.neo4j.bolt.connection.values.Value unsupportedDateTimeValue(DateTimeException e) {
        return new UnsupportedDateTimeValue(e);
    }

    public Map<String, org.neo4j.bolt.connection.values.Value> toBoltMap(Map<String, Value> map) {
        return Collections.unmodifiableMap(map);
    }

    public Map<String, Value> toDriverMap(Map<String, org.neo4j.bolt.connection.values.Value> map) {
        return Collections.unmodifiableMap(map);
    }

    public List<Value> toDriverList(List<org.neo4j.bolt.connection.values.Value> list) {
        return list;
    }
}

